/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.graphdb.spatial.CRS;
import org.neo4j.graphdb.spatial.Coordinate;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.values.AnyValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DoubleValue;
import org.neo4j.values.storable.NumberType;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.NumberValues;
import org.neo4j.values.storable.ScalarValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;
import org.neo4j.values.utils.PrettyPrinter;
import org.neo4j.values.virtual.MapValue;

public class PointValue
extends ScalarValue
implements Point,
Comparable<PointValue> {
    private CoordinateReferenceSystem crs;
    private double[] coordinate;
    private static Pattern mapPattern = Pattern.compile("\\{(.*)\\}");
    private static Pattern keyValuePattern = Pattern.compile("(?:\\A|,)\\s*+(?<k>[a-z_A-Z]\\w*+)\\s*:\\s*(?<v>[^\\s,]+)");
    private static Pattern quotesPattern = Pattern.compile("^[\"']|[\"']$");

    PointValue(CoordinateReferenceSystem crs, double ... coordinate) {
        this.crs = crs;
        this.coordinate = coordinate;
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        writer.writePoint(this.getCoordinateReferenceSystem(), this.coordinate);
    }

    @Override
    public String prettyPrint() {
        PrettyPrinter prettyPrinter = new PrettyPrinter();
        ((Value)this).writeTo(prettyPrinter);
        return prettyPrinter.value();
    }

    @Override
    public ValueGroup valueGroup() {
        return ValueGroup.GEOMETRY;
    }

    @Override
    public NumberType numberType() {
        return NumberType.NO_NUMBER;
    }

    @Override
    public boolean equals(Value other) {
        if (other instanceof PointValue) {
            PointValue pv = (PointValue)other;
            return Arrays.equals(this.coordinate, pv.coordinate) && this.getCoordinateReferenceSystem().equals(pv.getCoordinateReferenceSystem());
        }
        return false;
    }

    public boolean equals(Point other) {
        if (!other.getCRS().getHref().equals(this.getCRS().getHref())) {
            return false;
        }
        List otherCoordinate = other.getCoordinate().getCoordinate();
        if (otherCoordinate.size() != this.coordinate.length) {
            return false;
        }
        for (int i = 0; i < this.coordinate.length; ++i) {
            if ((Double)otherCoordinate.get(i) == this.coordinate[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean eq(Object other) {
        return other != null && (other instanceof Value && this.equals((Value)other) || other instanceof Point && this.equals((Point)other));
    }

    @Override
    public int compareTo(PointValue other) {
        int cmpCRS = this.crs.getCode() - other.crs.getCode();
        if (cmpCRS != 0) {
            return cmpCRS;
        }
        if (this.coordinate.length > other.coordinate.length) {
            return 1;
        }
        if (this.coordinate.length < other.coordinate.length) {
            return -1;
        }
        for (int i = 0; i < this.coordinate.length; ++i) {
            int cmpVal = Double.compare(this.coordinate[i], other.coordinate[i]);
            if (cmpVal == 0) continue;
            return cmpVal;
        }
        return 0;
    }

    @Override
    int unsafeCompareTo(Value otherValue) {
        return this.compareTo((PointValue)otherValue);
    }

    @Override
    Integer unsafeTernaryCompareTo(Value otherValue) {
        PointValue other = (PointValue)otherValue;
        if (this.crs.getCode() != other.crs.getCode() || this.coordinate.length != other.coordinate.length) {
            return null;
        }
        int result = 0;
        for (int i = 0; i < this.coordinate.length; ++i) {
            int cmpVal = Double.compare(this.coordinate[i], other.coordinate[i]);
            if (cmpVal == 0 || cmpVal == result) continue;
            if (cmpVal < 0 && result > 0 || cmpVal > 0 && result < 0) {
                return null;
            }
            result = cmpVal;
        }
        return result;
    }

    public Point asObjectCopy() {
        return this;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public double[] coordinate() {
        return this.coordinate;
    }

    @Override
    public int computeHash() {
        int result = 1;
        result = 31 * result + NumberValues.hash(this.crs.getCode());
        result = 31 * result + NumberValues.hash(this.coordinate);
        return result;
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapPoint(this);
    }

    public String toString() {
        return String.format("Point{ %s, %s}", this.getCoordinateReferenceSystem().getName(), Arrays.toString(this.coordinate));
    }

    public List<Coordinate> getCoordinates() {
        return Collections.singletonList(new Coordinate(this.coordinate));
    }

    public CRS getCRS() {
        return this.crs;
    }

    public boolean withinRange(PointValue lower, boolean includeLower, PointValue upper, boolean includeUpper) {
        boolean checkUpper;
        boolean checkLower = lower != null;
        boolean bl = checkUpper = upper != null;
        if (checkLower && this.crs.getCode() != lower.crs.getCode()) {
            return false;
        }
        if (checkUpper && this.crs.getCode() != upper.crs.getCode()) {
            return false;
        }
        for (int i = 0; i < this.coordinate.length; ++i) {
            int compareUpper;
            int compareLower;
            if (checkLower && ((compareLower = Double.compare(this.coordinate[i], lower.coordinate[i])) < 0 || compareLower == 0 && !includeLower)) {
                return false;
            }
            if (!checkUpper || (compareUpper = Double.compare(this.coordinate[i], upper.coordinate[i])) <= 0 && (compareUpper != 0 || includeUpper)) continue;
            return false;
        }
        return true;
    }

    public static PointValue fromMap(MapValue map) {
        AnyValue[] fields = new Value[PointValueField.values().length];
        for (PointValueField f : PointValueField.values()) {
            AnyValue fieldValue = map.get(f.name().toLowerCase());
            fields[f.ordinal()] = fieldValue != Values.NO_VALUE ? fieldValue : null;
        }
        return PointValue.fromInputFields(fields);
    }

    public static PointValue parse(CharSequence text) {
        return PointValue.parse(text, null);
    }

    public static PointValue parse(CharSequence text, AnyValue[] fieldsFromHeader) {
        AnyValue[] fieldsFromData = PointValue.parseIntoArray(text);
        if (fieldsFromHeader != null) {
            assert (fieldsFromData.length == fieldsFromHeader.length);
            for (int i = 0; i < fieldsFromData.length; ++i) {
                if (fieldsFromData[i] != null) continue;
                fieldsFromData[i] = fieldsFromHeader[i];
            }
        }
        return PointValue.fromInputFields(fieldsFromData);
    }

    public static AnyValue[] parseIntoArray(CharSequence text) {
        Matcher mapMatcher = mapPattern.matcher(text);
        if (!mapMatcher.find() || mapMatcher.groupCount() != 1) {
            String errorMessage = String.format("Failed to parse point value: '%s'", text);
            throw new IllegalArgumentException(errorMessage);
        }
        String mapContents = mapMatcher.group(1);
        if (mapContents.isEmpty()) {
            String errorMessage = String.format("Failed to parse point value: '%s'", text);
            throw new IllegalArgumentException(errorMessage);
        }
        Matcher matcher = keyValuePattern.matcher(mapContents);
        if (!matcher.find()) {
            String errorMessage = String.format("Failed to parse point value: '%s'", text);
            throw new IllegalArgumentException(errorMessage);
        }
        AnyValue[] fields = new Value[PointValueField.values().length];
        do {
            String key;
            if ((key = matcher.group("k")) == null) continue;
            PointValueField field = null;
            try {
                field = PointValueField.valueOf(PointValueField.class, key.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (field == null) continue;
            if (fields[field.ordinal()] != null) {
                String errorMessage = String.format("Failed to parse point value: '%s'. Duplicate field '%s' is not allowed.", text, key);
                throw new IllegalArgumentException(errorMessage);
            }
            String value = matcher.group("v");
            if (value == null) continue;
            switch (field.valueType()) {
                case NUMBER: {
                    DoubleValue doubleValue = Values.doubleValue(Double.parseDouble(value));
                    fields[field.ordinal()] = doubleValue;
                    break;
                }
                case TEXT: {
                    String unquotedValue = quotesPattern.matcher(value).replaceAll("");
                    fields[field.ordinal()] = Values.stringValue(unquotedValue);
                    break;
                }
            }
        } while (matcher.find());
        return fields;
    }

    private static CoordinateReferenceSystem findSpecifiedCRS(AnyValue[] fields) {
        AnyValue crsValue = fields[PointValueField.CRS.ordinal()];
        AnyValue sridValue = fields[PointValueField.SRID.ordinal()];
        if (crsValue != null && sridValue != null) {
            throw new IllegalArgumentException("Cannot specify both CRS and SRID");
        }
        if (crsValue != null) {
            TextValue crsName = (TextValue)crsValue;
            return CoordinateReferenceSystem.byName(crsName.stringValue());
        }
        if (sridValue != null) {
            NumberValue srid = (NumberValue)sridValue;
            return CoordinateReferenceSystem.get((int)srid.longValue());
        }
        return null;
    }

    private static PointValue fromInputFields(AnyValue[] fields) {
        double[] coordinates;
        CoordinateReferenceSystem crs = PointValue.findSpecifiedCRS(fields);
        AnyValue xValue = fields[PointValueField.X.ordinal()];
        AnyValue yValue = fields[PointValueField.Y.ordinal()];
        AnyValue latitudeValue = fields[PointValueField.LATITUDE.ordinal()];
        AnyValue longitudeValue = fields[PointValueField.LONGITUDE.ordinal()];
        if (xValue != null && yValue != null) {
            double[] dArray;
            double x = ((NumberValue)xValue).doubleValue();
            double y = ((NumberValue)yValue).doubleValue();
            AnyValue zValue = fields[PointValueField.Z.ordinal()];
            if (zValue != null) {
                double[] dArray2 = new double[3];
                dArray2[0] = x;
                dArray2[1] = y;
                dArray = dArray2;
                dArray2[2] = ((NumberValue)zValue).doubleValue();
            } else {
                double[] dArray3 = new double[2];
                dArray3[0] = x;
                dArray = dArray3;
                dArray3[1] = y;
            }
            coordinates = dArray;
            if (crs == null) {
                crs = coordinates.length == 3 ? CoordinateReferenceSystem.Cartesian_3D : CoordinateReferenceSystem.Cartesian;
            }
        } else if (latitudeValue != null && longitudeValue != null) {
            double x = ((NumberValue)longitudeValue).doubleValue();
            double y = ((NumberValue)latitudeValue).doubleValue();
            AnyValue zValue = fields[PointValueField.Z.ordinal()];
            AnyValue heightValue = fields[PointValueField.HEIGHT.ordinal()];
            coordinates = zValue != null ? new double[]{x, y, ((NumberValue)zValue).doubleValue()} : (heightValue != null ? new double[]{x, y, ((NumberValue)heightValue).doubleValue()} : new double[]{x, y});
            if (crs == null) {
                CoordinateReferenceSystem coordinateReferenceSystem = crs = coordinates.length == 3 ? CoordinateReferenceSystem.WGS84_3D : CoordinateReferenceSystem.WGS84;
            }
            if (!crs.isGeographic()) {
                throw new IllegalArgumentException("Geographic points does not support coordinate reference system: " + crs + ". This is set either in the csv header or the actual data column");
            }
        } else {
            if (crs == CoordinateReferenceSystem.Cartesian) {
                throw new IllegalArgumentException("A " + CoordinateReferenceSystem.Cartesian.getName() + " point must contain 'x' and 'y'");
            }
            if (crs == CoordinateReferenceSystem.Cartesian_3D) {
                throw new IllegalArgumentException("A " + CoordinateReferenceSystem.Cartesian_3D.getName() + " point must contain 'x', 'y' and 'z'");
            }
            if (crs == CoordinateReferenceSystem.WGS84) {
                throw new IllegalArgumentException("A " + CoordinateReferenceSystem.WGS84.getName() + " point must contain 'latitude' and 'longitude'");
            }
            if (crs == CoordinateReferenceSystem.WGS84_3D) {
                throw new IllegalArgumentException("A " + CoordinateReferenceSystem.WGS84_3D.getName() + " point must contain 'latitude', 'longitude' and 'height'");
            }
            throw new IllegalArgumentException("A point must contain either 'x' and 'y' or 'latitude' and 'longitude'");
        }
        if (crs.getDimension() != coordinates.length) {
            throw new IllegalArgumentException("Cannot create point with " + crs.getDimension() + "D coordinate reference system and " + coordinates.length + " coordinates. Please consider using equivalent " + coordinates.length + "D coordinate reference system");
        }
        return Values.pointValue(crs, coordinates);
    }

    public AnyValue get(String fieldName) {
        switch (fieldName.toLowerCase()) {
            case "x": {
                return this.getNthCoordinate(0, fieldName, false);
            }
            case "y": {
                return this.getNthCoordinate(1, fieldName, false);
            }
            case "z": {
                return this.getNthCoordinate(2, fieldName, false);
            }
            case "longitude": {
                return this.getNthCoordinate(0, fieldName, true);
            }
            case "latitude": {
                return this.getNthCoordinate(1, fieldName, true);
            }
            case "height": {
                return this.getNthCoordinate(2, fieldName, true);
            }
            case "crs": {
                return Values.stringValue(this.crs.toString());
            }
            case "srid": {
                return Values.intValue(this.crs.getCode());
            }
        }
        throw new IllegalArgumentException("No such field: " + fieldName);
    }

    private DoubleValue getNthCoordinate(int n, String fieldName, boolean onlyGeographic) {
        if (onlyGeographic && !this.getCoordinateReferenceSystem().isGeographic()) {
            throw new IllegalArgumentException("Field: " + fieldName + " is not available on cartesian point: " + this);
        }
        if (n >= this.coordinate().length) {
            throw new IllegalArgumentException("Field: " + fieldName + " is not available on point: " + this);
        }
        return Values.doubleValue(this.coordinate[n]);
    }

    private static enum PointValueField {
        X(ValueGroup.NUMBER),
        Y(ValueGroup.NUMBER),
        Z(ValueGroup.NUMBER),
        LATITUDE(ValueGroup.NUMBER),
        LONGITUDE(ValueGroup.NUMBER),
        HEIGHT(ValueGroup.NUMBER),
        CRS(ValueGroup.TEXT),
        SRID(ValueGroup.NUMBER);

        private ValueGroup valueType;

        private PointValueField(ValueGroup valueType) {
            this.valueType = valueType;
        }

        ValueGroup valueType() {
            return this.valueType;
        }
    }
}

