/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.time.Clock;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.IsoFields;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.values.AnyValue;
import org.neo4j.values.StructureBuilder;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;

public final class LocalDateTimeValue
extends TemporalValue<LocalDateTime, LocalDateTimeValue> {
    public static final LocalDateTimeValue MIN_VALUE = new LocalDateTimeValue(LocalDateTime.MIN);
    public static final LocalDateTimeValue MAX_VALUE = new LocalDateTimeValue(LocalDateTime.MAX);
    static final LocalDateTime DEFAULT_LOCAL_DATE_TIME = LocalDateTime.of(TemporalValue.Field.year.defaultValue, TemporalValue.Field.month.defaultValue, TemporalValue.Field.day.defaultValue, TemporalValue.Field.hour.defaultValue, TemporalValue.Field.minute.defaultValue);
    private final LocalDateTime value;
    private static final Pattern PATTERN = Pattern.compile(DateValue.DATE_PATTERN + "(?<time>T" + "(?:(?:(?<longHour>[0-9]{1,2})(?::(?<longMinute>[0-9]{1,2})(?::(?<longSecond>[0-9]{1,2})(?:\\.(?<longFraction>[0-9]{1,9}))?)?)?)|(?:(?<shortHour>[0-9]{2})(?:(?<shortMinute>[0-9]{2})(?:(?<shortSecond>[0-9]{2})(?:\\.(?<shortFraction>[0-9]{1,9}))?)?)?))" + ")?", 2);

    public static LocalDateTimeValue localDateTime(DateValue date, LocalTimeValue time) {
        return new LocalDateTimeValue(LocalDateTime.of(date.temporal(), time.temporal()));
    }

    public static LocalDateTimeValue localDateTime(int year, int month, int day, int hour, int minute, int second, int nanoOfSecond) {
        return new LocalDateTimeValue(LocalDateTime.of(year, month, day, hour, minute, second, nanoOfSecond));
    }

    public static LocalDateTimeValue localDateTime(LocalDateTime value) {
        return new LocalDateTimeValue(Objects.requireNonNull(value, "LocalDateTime"));
    }

    public static LocalDateTimeValue localDateTime(long epochSecond, long nano) {
        return new LocalDateTimeValue(LocalDateTime.ofInstant(Instant.ofEpochSecond(epochSecond, nano), ZoneOffset.UTC));
    }

    public static LocalDateTimeValue inUTC(DateTimeValue datetime) {
        return new LocalDateTimeValue(datetime.temporal().withZoneSameInstant(ZoneOffset.UTC).toLocalDateTime());
    }

    public static LocalDateTimeValue parse(CharSequence text) {
        return LocalDateTimeValue.parse(LocalDateTimeValue.class, PATTERN, LocalDateTimeValue::parse, text);
    }

    public static LocalDateTimeValue parse(TextValue text) {
        return LocalDateTimeValue.parse(LocalDateTimeValue.class, PATTERN, LocalDateTimeValue::parse, text);
    }

    public static LocalDateTimeValue now(Clock clock) {
        return new LocalDateTimeValue(LocalDateTime.now(clock));
    }

    public static LocalDateTimeValue now(Clock clock, String timezone) {
        return LocalDateTimeValue.now(clock.withZone(DateTimeValue.parseZoneName(timezone)));
    }

    public static LocalDateTimeValue build(MapValue map, Supplier<ZoneId> defaultZone) {
        return (LocalDateTimeValue)StructureBuilder.build(LocalDateTimeValue.builder(defaultZone), map);
    }

    public static LocalDateTimeValue select(AnyValue from, Supplier<ZoneId> defaultZone) {
        return LocalDateTimeValue.builder(defaultZone).selectDateTime(from);
    }

    public static LocalDateTimeValue truncate(TemporalUnit unit, TemporalValue input, MapValue fields, Supplier<ZoneId> defaultZone) {
        Pair<LocalDate, LocalTime> pair = LocalDateTimeValue.getTruncatedDateAndTime(unit, input, "local date time");
        LocalDate truncatedDate = (LocalDate)pair.first();
        LocalTime truncatedTime = (LocalTime)pair.other();
        LocalDateTime truncatedLDT = LocalDateTime.of(truncatedDate, truncatedTime);
        if (fields.size() == 0) {
            return LocalDateTimeValue.localDateTime(truncatedLDT);
        }
        Map<String, AnyValue> updatedFields = fields.getMapCopy();
        truncatedLDT = LocalDateTimeValue.updateFieldMapWithConflictingSubseconds(updatedFields, unit, truncatedLDT);
        if (updatedFields.size() == 0) {
            return LocalDateTimeValue.localDateTime(truncatedLDT);
        }
        updatedFields.put("datetime", LocalDateTimeValue.localDateTime(truncatedLDT));
        return LocalDateTimeValue.build(VirtualValues.map(updatedFields), defaultZone);
    }

    static DateTimeValue.DateTimeBuilder<LocalDateTimeValue> builder(Supplier<ZoneId> defaultZone) {
        return new DateTimeValue.DateTimeBuilder<LocalDateTimeValue>(defaultZone){

            @Override
            protected boolean supportsTimeZone() {
                return false;
            }

            @Override
            protected boolean supportsEpoch() {
                return false;
            }

            @Override
            public LocalDateTimeValue buildInternal() {
                LocalDateTime result;
                boolean selectingDate = this.fields.containsKey((Object)TemporalValue.Field.date);
                boolean selectingTime = this.fields.containsKey((Object)TemporalValue.Field.time);
                boolean selectingDateTime = this.fields.containsKey((Object)TemporalValue.Field.datetime);
                if (selectingDateTime) {
                    AnyValue dtField = (AnyValue)this.fields.get((Object)TemporalValue.Field.datetime);
                    if (!(dtField instanceof TemporalValue)) {
                        throw new IllegalArgumentException(String.format("Cannot construct local date time from: %s", dtField));
                    }
                    TemporalValue dt = (TemporalValue)dtField;
                    result = LocalDateTime.of(dt.getDatePart(), dt.getLocalTimePart());
                } else if (selectingTime || selectingDate) {
                    LocalDate date;
                    LocalTime time;
                    if (selectingTime) {
                        AnyValue timeField = (AnyValue)this.fields.get((Object)TemporalValue.Field.time);
                        if (!(timeField instanceof TemporalValue)) {
                            throw new IllegalArgumentException(String.format("Cannot construct local time from: %s", timeField));
                        }
                        TemporalValue t = (TemporalValue)timeField;
                        time = t.getLocalTimePart();
                    } else {
                        time = LocalTimeValue.DEFAULT_LOCAL_TIME;
                    }
                    if (selectingDate) {
                        AnyValue dateField = (AnyValue)this.fields.get((Object)TemporalValue.Field.date);
                        if (!(dateField instanceof TemporalValue)) {
                            throw new IllegalArgumentException(String.format("Cannot construct date from: %s", dateField));
                        }
                        TemporalValue t = (TemporalValue)dateField;
                        date = t.getDatePart();
                    } else {
                        date = DateValue.DEFAULT_CALENDER_DATE;
                    }
                    result = LocalDateTime.of(date, time);
                } else {
                    result = DEFAULT_LOCAL_DATE_TIME;
                }
                if (this.fields.containsKey((Object)TemporalValue.Field.week) && !selectingDate && !selectingDateTime) {
                    result = result.with(IsoFields.WEEK_BASED_YEAR, IntegralValue.safeCastIntegral(TemporalValue.Field.year.name(), (AnyValue)this.fields.get((Object)TemporalValue.Field.year), TemporalValue.Field.year.defaultValue)).with(IsoFields.WEEK_OF_WEEK_BASED_YEAR, 1L).with(ChronoField.DAY_OF_WEEK, 1L);
                }
                result = this.assignAllFields(result);
                return LocalDateTimeValue.localDateTime(result);
            }

            private LocalDateTime getLocalDateTimeOf(AnyValue temporal) {
                if (temporal instanceof TemporalValue) {
                    TemporalValue v = (TemporalValue)temporal;
                    LocalDate datePart = v.getDatePart();
                    LocalTime timePart = v.getLocalTimePart();
                    return LocalDateTime.of(datePart, timePart);
                }
                throw new IllegalArgumentException(String.format("Cannot construct date from: %s", temporal));
            }

            @Override
            protected LocalDateTimeValue selectDateTime(AnyValue datetime) {
                if (datetime instanceof LocalDateTimeValue) {
                    return (LocalDateTimeValue)datetime;
                }
                return LocalDateTimeValue.localDateTime(this.getLocalDateTimeOf(datetime));
            }
        };
    }

    private LocalDateTimeValue(LocalDateTime value) {
        this.value = value;
    }

    @Override
    int unsafeCompareTo(Value otherValue) {
        LocalDateTimeValue other = (LocalDateTimeValue)otherValue;
        return this.value.compareTo(other.value);
    }

    @Override
    LocalDateTime temporal() {
        return this.value;
    }

    @Override
    LocalDate getDatePart() {
        return this.value.toLocalDate();
    }

    @Override
    LocalTime getLocalTimePart() {
        return this.value.toLocalTime();
    }

    @Override
    OffsetTime getTimePart(Supplier<ZoneId> defaultZone) {
        ZoneOffset currentOffset = ZonedDateTime.ofInstant(Instant.now(), defaultZone.get()).getOffset();
        return OffsetTime.of(this.value.toLocalTime(), currentOffset);
    }

    @Override
    ZoneId getZoneId(Supplier<ZoneId> defaultZone) {
        return defaultZone.get();
    }

    @Override
    ZoneId getZoneId() {
        throw new UnsupportedTemporalTypeException("Cannot get the timezone of" + this);
    }

    @Override
    ZoneOffset getZoneOffset() {
        throw new UnsupportedTemporalTypeException("Cannot get the offset of" + this);
    }

    @Override
    public boolean supportsTimeZone() {
        return false;
    }

    @Override
    boolean hasTime() {
        return true;
    }

    @Override
    public boolean equals(Value other) {
        return other instanceof LocalDateTimeValue && this.value.equals(((LocalDateTimeValue)other).value);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        writer.writeLocalDateTime(this.value.toEpochSecond(ZoneOffset.UTC), this.value.getNano());
    }

    @Override
    public String prettyPrint() {
        return this.value.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
    }

    @Override
    public ValueGroup valueGroup() {
        return ValueGroup.LOCAL_DATE_TIME;
    }

    @Override
    protected int computeHash() {
        return this.value.toInstant(ZoneOffset.UTC).hashCode();
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapLocalDateTime(this);
    }

    @Override
    public LocalDateTimeValue add(DurationValue duration) {
        return this.replacement(this.value.plus(duration));
    }

    @Override
    public LocalDateTimeValue sub(DurationValue duration) {
        return this.replacement(this.value.minus(duration));
    }

    @Override
    LocalDateTimeValue replacement(LocalDateTime dateTime) {
        return dateTime == this.value ? this : new LocalDateTimeValue(dateTime);
    }

    private static LocalDateTimeValue parse(Matcher matcher) {
        return LocalDateTimeValue.localDateTime(LocalDateTime.of(DateValue.parseDate(matcher), LocalDateTimeValue.optTime(matcher)));
    }

    static LocalTime optTime(Matcher matcher) {
        return matcher.group("time") != null ? LocalTimeValue.parseTime(matcher) : LocalTime.MIN;
    }
}

