/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.DoubleValue;
import org.neo4j.values.storable.FloatingPointValue;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.NumberType;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.NumberValues;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.utils.ValueMath;

public abstract class IntegralValue
extends NumberValue {
    public static long safeCastIntegral(String name, AnyValue value, long defaultValue) {
        if (value == null || value == Values.NO_VALUE) {
            return defaultValue;
        }
        if (value instanceof IntegralValue) {
            return ((IntegralValue)value).longValue();
        }
        throw new IllegalArgumentException(name + " must be an integer value, but was a " + value.getClass().getSimpleName());
    }

    @Override
    public boolean equals(long x) {
        return this.longValue() == x;
    }

    @Override
    public boolean equals(double x) {
        return NumberValues.numbersEqual(x, this.longValue());
    }

    @Override
    public final int computeHash() {
        return NumberValues.hash(this.longValue());
    }

    @Override
    public boolean eq(Object other) {
        return other != null && other instanceof Value && this.equals((Value)other);
    }

    @Override
    public final boolean equals(Value other) {
        if (other instanceof IntegralValue) {
            IntegralValue that = (IntegralValue)other;
            return this.longValue() == that.longValue();
        }
        if (other instanceof FloatingPointValue) {
            FloatingPointValue that = (FloatingPointValue)other;
            return NumberValues.numbersEqual(that.doubleValue(), this.longValue());
        }
        return false;
    }

    @Override
    public int compareTo(IntegralValue other) {
        return Long.compare(this.longValue(), other.longValue());
    }

    @Override
    public int compareTo(FloatingPointValue other) {
        return NumberValues.compareLongAgainstDouble(this.longValue(), other.doubleValue());
    }

    @Override
    public NumberType numberType() {
        return NumberType.INTEGRAL;
    }

    @Override
    public double doubleValue() {
        return this.longValue();
    }

    @Override
    public LongValue minus(long b) {
        return ValueMath.subtract(this.longValue(), b);
    }

    @Override
    public DoubleValue minus(double b) {
        return ValueMath.subtract((double)this.longValue(), b);
    }

    @Override
    public LongValue plus(long b) {
        return ValueMath.add(this.longValue(), b);
    }

    @Override
    public DoubleValue plus(double b) {
        return ValueMath.add((double)this.longValue(), b);
    }

    @Override
    public LongValue times(long b) {
        return ValueMath.multiply(this.longValue(), b);
    }

    @Override
    public DoubleValue times(double b) {
        return ValueMath.multiply((double)this.longValue(), b);
    }

    @Override
    public LongValue dividedBy(long b) {
        return Values.longValue(this.longValue() / b);
    }

    @Override
    public DoubleValue dividedBy(double b) {
        return Values.doubleValue(this.doubleValue() / b);
    }
}

