/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.neo4j.graphdb.spatial.CRS;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.values.storable.CRSCalculator;
import org.neo4j.values.storable.CRSTable;

public class CoordinateReferenceSystem
implements CRS {
    public static final CoordinateReferenceSystem Cartesian = new CoordinateReferenceSystem("cartesian", CRSTable.SR_ORG, 7203, 2, false);
    public static final CoordinateReferenceSystem Cartesian_3D = new CoordinateReferenceSystem("cartesian-3D", CRSTable.SR_ORG, 9157, 3, false);
    public static final CoordinateReferenceSystem WGS84 = new CoordinateReferenceSystem("WGS-84", CRSTable.EPSG, 4326, 2, true);
    public static final CoordinateReferenceSystem WGS84_3D = new CoordinateReferenceSystem("WGS-84-3D", CRSTable.EPSG, 4979, 3, true);
    private static final CoordinateReferenceSystem[] TYPES = new CoordinateReferenceSystem[]{Cartesian, Cartesian_3D, WGS84, WGS84_3D};
    private static final Map<String, CoordinateReferenceSystem> all_by_name = new HashMap<String, CoordinateReferenceSystem>(TYPES.length);
    private static final Map<String, CoordinateReferenceSystem> all_by_href = new HashMap<String, CoordinateReferenceSystem>(TYPES.length);
    private final String name;
    private final CRSTable table;
    private final int code;
    private final String href;
    private final int dimension;
    private final boolean geographic;
    private final Pair<double[], double[]> indexEnvelope;
    private final CRSCalculator calculator;

    public static Iterator<CoordinateReferenceSystem> all() {
        return Iterators.iterator((Object[])TYPES);
    }

    public static CoordinateReferenceSystem get(int tableId, int code) {
        CRSTable table = CRSTable.find(tableId);
        String href = table.href(code);
        if (all_by_href.containsKey(href.toLowerCase())) {
            return all_by_href.get(href.toLowerCase());
        }
        throw new IllegalArgumentException("Unknown coordinate reference system: " + tableId + "-" + code);
    }

    public static CoordinateReferenceSystem get(CRS crs) {
        Objects.requireNonNull(crs);
        return CoordinateReferenceSystem.get(crs.getHref());
    }

    public static CoordinateReferenceSystem byName(String name) {
        if (all_by_name.containsKey(name.toLowerCase())) {
            return all_by_name.get(name.toLowerCase());
        }
        throw new IllegalArgumentException("Unknown coordinate reference system: " + name);
    }

    public static CoordinateReferenceSystem get(String href) {
        if (all_by_href.containsKey(href.toLowerCase())) {
            return all_by_href.get(href.toLowerCase());
        }
        throw new IllegalArgumentException("Unknown coordinate reference system: " + href);
    }

    public static CoordinateReferenceSystem get(int code) {
        for (CRSTable table : CRSTable.values()) {
            String href = table.href(code);
            if (!all_by_href.containsKey(href.toLowerCase())) continue;
            return all_by_href.get(href.toLowerCase());
        }
        throw new IllegalArgumentException("Unknown coordinate reference system code: " + code);
    }

    private CoordinateReferenceSystem(String name, CRSTable table, int code, int dimension, boolean geographic) {
        this.name = name;
        this.table = table;
        this.code = code;
        this.href = table.href(code);
        this.dimension = dimension;
        this.geographic = geographic;
        this.indexEnvelope = CoordinateReferenceSystem.envelopeFromCRS(dimension, geographic, -1000000.0, 1000000.0);
        this.calculator = geographic ? new CRSCalculator.GeographicCalculator(dimension) : new CRSCalculator.CartesianCalculator(dimension);
    }

    public String toString() {
        return this.name;
    }

    public int getCode() {
        return this.code;
    }

    public String getType() {
        return this.name;
    }

    public String getHref() {
        return this.href;
    }

    public String getName() {
        return this.name;
    }

    public CRSTable getTable() {
        return this.table;
    }

    public int getDimension() {
        return this.dimension;
    }

    public boolean isGeographic() {
        return this.geographic;
    }

    public CRSCalculator getCalculator() {
        return this.calculator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoordinateReferenceSystem that = (CoordinateReferenceSystem)o;
        return this.href.equals(that.href);
    }

    public int hashCode() {
        return this.href.hashCode();
    }

    public Pair<double[], double[]> getIndexEnvelope() {
        return this.indexEnvelope;
    }

    private static Pair<double[], double[]> envelopeFromCRS(int dimension, boolean geographic, double minCartesian, double maxCartesian) {
        assert (dimension >= 2);
        double[] min = new double[dimension];
        double[] max = new double[dimension];
        int cartesianStartIndex = 0;
        if (geographic) {
            min[0] = -180.0;
            max[0] = 180.0;
            min[1] = -90.0;
            max[1] = 90.0;
            cartesianStartIndex = 2;
        }
        for (int i = cartesianStartIndex; i < dimension; ++i) {
            min[i] = minCartesian;
            max[i] = maxCartesian;
        }
        return Pair.of((Object)min, (Object)max);
    }

    static {
        for (CoordinateReferenceSystem crs : TYPES) {
            all_by_name.put(crs.name.toLowerCase(), crs);
            all_by_href.put(crs.href.toLowerCase(), crs);
        }
    }
}

