/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.utils;

import java.util.Iterator;
import org.neo4j.collection.trackable.HeapTrackingCollections;
import org.neo4j.collection.trackable.HeapTrackingUnifiedSet;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.AnyValue;
import org.neo4j.values.Equality;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.utils.SimpleIdentityCache;
import org.neo4j.values.utils.ValueBooleanLogic;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.SetListValue;

public class InCache
implements AutoCloseable {
    private final SimpleIdentityCache<ListValue, DelayedInCacheChecker> seen;

    public InCache() {
        this(16);
    }

    public InCache(int maxSize) {
        this.seen = new SimpleIdentityCache(maxSize);
    }

    public Value check(AnyValue value, ListValue list, MemoryTracker memoryTracker) {
        if (list instanceof SetListValue || list.actualSize() < 128L || value == Values.NO_VALUE) {
            return ValueBooleanLogic.in(value, list);
        }
        return this.seen.getOrCache(list, oldValue -> {
            if (oldValue != null) {
                oldValue.close();
            }
            return new DelayedInCacheChecker();
        }).check(value, list, memoryTracker);
    }

    @Override
    public void close() {
        this.seen.foreach((k, v) -> v.close());
    }

    private static class DelayedInCacheChecker
    implements AutoCloseable {
        private static final int DEFAULT_DELAY = 1;
        private HeapTrackingUnifiedSet<AnyValue> seen;
        private Iterator<AnyValue> iterator;
        private boolean seenUndefined;
        private int cacheHits;
        private final int delay;

        private DelayedInCacheChecker() {
            this(1);
        }

        private DelayedInCacheChecker(int delay) {
            this.delay = delay;
        }

        private Value check(AnyValue value, ListValue list, MemoryTracker memoryTracker) {
            assert (value != Values.NO_VALUE);
            if (this.cacheHits++ < this.delay) {
                return ValueBooleanLogic.in(value, list);
            }
            if (this.iterator == null) {
                this.iterator = list.iterator();
                this.seen = HeapTrackingCollections.newSet((MemoryTracker)memoryTracker);
            }
            if (this.seen.contains((Object)value)) {
                return Values.TRUE;
            }
            while (this.iterator.hasNext()) {
                AnyValue next = this.iterator.next();
                if (next == Values.NO_VALUE) {
                    this.seenUndefined = true;
                    continue;
                }
                this.seen.add((Object)next);
                if (next.ternaryEquals(value) != Equality.TRUE) continue;
                return Values.TRUE;
            }
            if (this.seenUndefined) {
                return Values.NO_VALUE;
            }
            if (value instanceof SequenceValue || value instanceof MapValue) {
                boolean undefinedEquality = this.seen.stream().anyMatch(seenValue -> value.ternaryEquals((AnyValue)seenValue) == Equality.UNDEFINED);
                return undefinedEquality ? Values.NO_VALUE : Values.FALSE;
            }
            return Values.FALSE;
        }

        @Override
        public void close() {
            if (this.seen != null) {
                this.seen.close();
            }
        }
    }
}

