/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.internal.dragons;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import org.neo4j.unsafe.impl.internal.dragons.FeatureToggles;
import sun.misc.Unsafe;

public final class UnsafeUtil {
    private static final boolean DIRTY_MEMORY = FeatureToggles.flag(UnsafeUtil.class, "DIRTY_MEMORY", false);
    private static final Unsafe unsafe = UnsafeUtil.getUnsafe();
    private static final MethodHandle sharedStringConstructor;
    private static final String allowUnalignedMemoryAccessProperty = "org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil.allowUnalignedMemoryAccess";
    private static final Class<?> directByteBufferClass;
    private static final Constructor<?> directByteBufferCtor;
    private static final long directByteBufferMarkOffset;
    private static final long directByteBufferPositionOffset;
    private static final long directByteBufferLimitOffset;
    private static final long directByteBufferCapacityOffset;
    private static final long directByteBufferAddressOffset;
    private static final int pageSize;
    public static final boolean allowUnalignedMemoryAccess;
    public static final boolean storeByteOrderIsNative;

    private static Unsafe getUnsafe() {
        try {
            PrivilegedExceptionAction<Unsafe> getUnsafe = () -> {
                try {
                    return Unsafe.getUnsafe();
                }
                catch (Exception e) {
                    Field[] fields;
                    Class<Unsafe> type = Unsafe.class;
                    for (Field field : fields = type.getDeclaredFields()) {
                        if (!Modifier.isStatic(field.getModifiers()) || !type.isAssignableFrom(field.getType())) continue;
                        field.setAccessible(true);
                        return (Unsafe)type.cast(field.get(null));
                    }
                    LinkageError error = new LinkageError("No static field of type sun.misc.Unsafe");
                    error.addSuppressed(e);
                    throw error;
                }
            };
            return AccessController.doPrivileged(getUnsafe);
        }
        catch (Exception e) {
            throw new LinkageError("Cannot access sun.misc.Unsafe", e);
        }
    }

    public static void assertHasUnsafe() {
        if (unsafe == null) {
            throw new LinkageError("Unsafe not available");
        }
    }

    private static MethodHandle getSharedStringConstructorMethodHandle(MethodHandles.Lookup lookup) {
        try {
            Constructor constructor = String.class.getDeclaredConstructor(char[].class, Boolean.TYPE);
            constructor.setAccessible(true);
            return lookup.unreflectConstructor(constructor);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static long getFieldOffset(Class<?> type, String field) {
        try {
            return unsafe.objectFieldOffset(type.getDeclaredField(field));
        }
        catch (NoSuchFieldException e) {
            String message = "Could not get offset of '" + field + "' field on type " + type;
            throw new LinkageError(message, e);
        }
    }

    public static int getAndAddInt(Object obj, long offset, int delta) {
        return unsafe.getAndAddInt(obj, offset, delta);
    }

    public static void loadFence() {
        unsafe.loadFence();
    }

    public static boolean compareAndSwapLong(Object obj, long offset, long expected, long update) {
        return unsafe.compareAndSwapLong(obj, offset, expected, update);
    }

    public static boolean compareAndSwapObject(Object obj, long offset, Object expected, Object update) {
        return unsafe.compareAndSwapObject(obj, offset, expected, update);
    }

    public static Object getAndSetObject(Object obj, long offset, Object newValue) {
        return unsafe.getAndSetObject(obj, offset, newValue);
    }

    public static String newSharedArrayString(char[] chars) {
        if (sharedStringConstructor != null) {
            try {
                return sharedStringConstructor.invokeExact(chars, true);
            }
            catch (Throwable throwable) {
                throw new LinkageError("Unexpected 'String constructor' intrinsic failure", throwable);
            }
        }
        return new String(chars);
    }

    public static long allocateMemory(long sizeInBytes) {
        long pointer = unsafe.allocateMemory(sizeInBytes);
        if (DIRTY_MEMORY) {
            UnsafeUtil.setMemory(pointer, sizeInBytes, (byte)-91);
        }
        return pointer;
    }

    public static void free(long pointer) {
        unsafe.freeMemory(pointer);
    }

    public static int pageSize() {
        return pageSize;
    }

    public static void putBoolean(Object obj, long offset, boolean value) {
        unsafe.putBoolean(obj, offset, value);
    }

    public static boolean getBoolean(Object obj, long offset) {
        return unsafe.getBoolean(obj, offset);
    }

    public static void putBooleanVolatile(Object obj, long offset, boolean value) {
        unsafe.putBooleanVolatile(obj, offset, value);
    }

    public static boolean getBooleanVolatile(Object obj, long offset) {
        return unsafe.getBooleanVolatile(obj, offset);
    }

    public static void putByte(long address, byte value) {
        unsafe.putByte(address, value);
    }

    public static byte getByte(long address) {
        return unsafe.getByte(address);
    }

    public static void putByteVolatile(long address, byte value) {
        unsafe.putByteVolatile(null, address, value);
    }

    public static byte getByteVolatile(long address) {
        return unsafe.getByteVolatile(null, address);
    }

    public static void putByte(Object obj, long offset, byte value) {
        unsafe.putByte(obj, offset, value);
    }

    public static byte getByte(Object obj, long offset) {
        return unsafe.getByte(obj, offset);
    }

    public static byte getByteVolatile(Object obj, long offset) {
        return unsafe.getByteVolatile(obj, offset);
    }

    public static void putByteVolatile(Object obj, long offset, byte value) {
        unsafe.putByteVolatile(obj, offset, value);
    }

    public static void putShort(long address, short value) {
        unsafe.putShort(address, value);
    }

    public static short getShort(long address) {
        return unsafe.getShort(address);
    }

    public static void putShortVolatile(long address, short value) {
        unsafe.putShortVolatile(null, address, value);
    }

    public static short getShortVolatile(long address) {
        return unsafe.getShortVolatile(null, address);
    }

    public static void putShort(Object obj, long offset, short value) {
        unsafe.putShort(obj, offset, value);
    }

    public static short getShort(Object obj, long offset) {
        return unsafe.getShort(obj, offset);
    }

    public static void putShortVolatile(Object obj, long offset, short value) {
        unsafe.putShortVolatile(obj, offset, value);
    }

    public static short getShortVolatile(Object obj, long offset) {
        return unsafe.getShortVolatile(obj, offset);
    }

    public static void putFloat(long address, float value) {
        unsafe.putFloat(address, value);
    }

    public static float getFloat(long address) {
        return unsafe.getFloat(address);
    }

    public static void putFloatVolatile(long address, float value) {
        unsafe.putFloatVolatile(null, address, value);
    }

    public static float getFloatVolatile(long address) {
        return unsafe.getFloatVolatile(null, address);
    }

    public static void putFloat(Object obj, long offset, float value) {
        unsafe.putFloat(obj, offset, value);
    }

    public static float getFloat(Object obj, long offset) {
        return unsafe.getFloat(obj, offset);
    }

    public static void putFloatVolatile(Object obj, long offset, float value) {
        unsafe.putFloatVolatile(obj, offset, value);
    }

    public static float getFloatVolatile(Object obj, long offset) {
        return unsafe.getFloatVolatile(obj, offset);
    }

    public static void putChar(long address, char value) {
        unsafe.putChar(address, value);
    }

    public static char getChar(long address) {
        return unsafe.getChar(address);
    }

    public static void putCharVolatile(long address, char value) {
        unsafe.putCharVolatile(null, address, value);
    }

    public static char getCharVolatile(long address) {
        return unsafe.getCharVolatile(null, address);
    }

    public static void putChar(Object obj, long offset, char value) {
        unsafe.putChar(obj, offset, value);
    }

    public static char getChar(Object obj, long offset) {
        return unsafe.getChar(obj, offset);
    }

    public static void putCharVolatile(Object obj, long offset, char value) {
        unsafe.putCharVolatile(obj, offset, value);
    }

    public static char getCharVolatile(Object obj, long offset) {
        return unsafe.getCharVolatile(obj, offset);
    }

    public static void putInt(long address, int value) {
        unsafe.putInt(address, value);
    }

    public static int getInt(long address) {
        return unsafe.getInt(address);
    }

    public static void putIntVolatile(long address, int value) {
        unsafe.putIntVolatile(null, address, value);
    }

    public static int getIntVolatile(long address) {
        return unsafe.getIntVolatile(null, address);
    }

    public static void putInt(Object obj, long offset, int value) {
        unsafe.putInt(obj, offset, value);
    }

    public static int getInt(Object obj, long offset) {
        return unsafe.getInt(obj, offset);
    }

    public static void putIntVolatile(Object obj, long offset, int value) {
        unsafe.putIntVolatile(obj, offset, value);
    }

    public static int getIntVolatile(Object obj, long offset) {
        return unsafe.getIntVolatile(obj, offset);
    }

    public static void putLongVolatile(long address, long value) {
        unsafe.putLongVolatile(null, address, value);
    }

    public static long getLongVolatile(long address) {
        return unsafe.getLongVolatile(null, address);
    }

    public static void putLong(long address, long value) {
        unsafe.putLong(address, value);
    }

    public static long getLong(long address) {
        return unsafe.getLong(address);
    }

    public static void putLong(Object obj, long offset, long value) {
        unsafe.putLong(obj, offset, value);
    }

    public static long getLong(Object obj, long offset) {
        return unsafe.getLong(obj, offset);
    }

    public static void putLongVolatile(Object obj, long offset, long value) {
        unsafe.putLongVolatile(obj, offset, value);
    }

    public static long getLongVolatile(Object obj, long offset) {
        return unsafe.getLongVolatile(obj, offset);
    }

    public static void putDouble(long address, double value) {
        unsafe.putDouble(address, value);
    }

    public static double getDouble(long address) {
        return unsafe.getDouble(address);
    }

    public static void putDoubleVolatile(long address, double value) {
        unsafe.putDoubleVolatile(null, address, value);
    }

    public static double getDoubleVolatile(long address) {
        return unsafe.getDoubleVolatile(null, address);
    }

    public static void putDouble(Object obj, long offset, double value) {
        unsafe.putDouble(obj, offset, value);
    }

    public static double getDouble(Object obj, long offset) {
        return unsafe.getDouble(obj, offset);
    }

    public static void putDoubleVolatile(Object obj, long offset, double value) {
        unsafe.putDoubleVolatile(obj, offset, value);
    }

    public static double getDoubleVolatile(Object obj, long offset) {
        return unsafe.getDoubleVolatile(obj, offset);
    }

    public static void putObject(Object obj, long offset, Object value) {
        unsafe.putObject(obj, offset, value);
    }

    public static Object getObject(Object obj, long offset) {
        return unsafe.getObject(obj, offset);
    }

    public static Object getObjectVolatile(Object obj, long offset) {
        return unsafe.getObjectVolatile(obj, offset);
    }

    public static void putObjectVolatile(Object obj, long offset, Object value) {
        unsafe.putObjectVolatile(obj, offset, value);
    }

    public static int arrayBaseOffset(Class klass) {
        return unsafe.arrayBaseOffset(klass);
    }

    public static int arrayIndexScale(Class klass) {
        int scale = unsafe.arrayIndexScale(klass);
        if (scale == 0) {
            throw new AssertionError((Object)("Array type too narrow for unsafe access: " + klass));
        }
        return scale;
    }

    public static int arrayOffset(int index, int base, int scale) {
        return base + index * scale;
    }

    public static void setMemory(long address, long bytes, byte value) {
        unsafe.setMemory(address, bytes, value);
    }

    public static void copyMemory(long srcAddress, long destAddress, long bytes) {
        unsafe.copyMemory(srcAddress, destAddress, bytes);
    }

    public static ByteBuffer newDirectByteBuffer(long addr, int cap) throws Exception {
        if (directByteBufferCtor == null) {
            Object dbb = unsafe.allocateInstance(directByteBufferClass);
            UnsafeUtil.initDirectByteBuffer(dbb, addr, cap);
            return (ByteBuffer)dbb;
        }
        return (ByteBuffer)directByteBufferCtor.newInstance(addr, cap);
    }

    public static void initDirectByteBuffer(Object dbb, long addr, int cap) {
        unsafe.putInt(dbb, directByteBufferMarkOffset, -1);
        unsafe.putInt(dbb, directByteBufferPositionOffset, 0);
        unsafe.putInt(dbb, directByteBufferLimitOffset, cap);
        unsafe.putInt(dbb, directByteBufferCapacityOffset, cap);
        unsafe.putLong(dbb, directByteBufferAddressOffset, addr);
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        sharedStringConstructor = UnsafeUtil.getSharedStringConstructorMethodHandle(lookup);
        Class<?> dbbClass = null;
        Constructor<?> ctor = null;
        long dbbMarkOffset = 0L;
        long dbbPositionOffset = 0L;
        long dbbLimitOffset = 0L;
        long dbbCapacityOffset = 0L;
        long dbbAddressOffset = 0L;
        int ps = 4096;
        try {
            dbbClass = Class.forName("java.nio.DirectByteBuffer");
            Class<?> bufferClass = Class.forName("java.nio.Buffer");
            dbbMarkOffset = unsafe.objectFieldOffset(bufferClass.getDeclaredField("mark"));
            dbbPositionOffset = unsafe.objectFieldOffset(bufferClass.getDeclaredField("position"));
            dbbLimitOffset = unsafe.objectFieldOffset(bufferClass.getDeclaredField("limit"));
            dbbCapacityOffset = unsafe.objectFieldOffset(bufferClass.getDeclaredField("capacity"));
            dbbAddressOffset = unsafe.objectFieldOffset(bufferClass.getDeclaredField("address"));
            ps = unsafe.pageSize();
        }
        catch (Throwable e) {
            if (dbbClass == null) {
                throw new LinkageError("Cannot to link java.nio.DirectByteBuffer", e);
            }
            try {
                ctor = dbbClass.getConstructor(Long.TYPE, Integer.TYPE);
                ctor.setAccessible(true);
            }
            catch (NoSuchMethodException e1) {
                throw new LinkageError("Cannot find JNI constructor for java.nio.DirectByteBuffer", e1);
            }
        }
        directByteBufferClass = dbbClass;
        directByteBufferCtor = ctor;
        directByteBufferMarkOffset = dbbMarkOffset;
        directByteBufferPositionOffset = dbbPositionOffset;
        directByteBufferLimitOffset = dbbLimitOffset;
        directByteBufferCapacityOffset = dbbCapacityOffset;
        directByteBufferAddressOffset = dbbAddressOffset;
        pageSize = ps;
        String alignmentProperty = System.getProperty(allowUnalignedMemoryAccessProperty);
        if (alignmentProperty != null && (alignmentProperty.equalsIgnoreCase("true") || alignmentProperty.equalsIgnoreCase("false"))) {
            allowUnalignedMemoryAccess = Boolean.parseBoolean(alignmentProperty);
        } else {
            boolean unaligned;
            String arch;
            switch (arch = System.getProperty("os.arch", "?")) {
                case "x86_64": 
                case "i386": 
                case "x86": 
                case "amd64": 
                case "ppc64": 
                case "ppc64le": 
                case "ppc64be": {
                    unaligned = true;
                    break;
                }
                default: {
                    unaligned = false;
                }
            }
            allowUnalignedMemoryAccess = unaligned;
        }
        storeByteOrderIsNative = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
    }
}

