/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.token;

import org.neo4j.common.TokenNameLookup;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.TokenHolder;
import org.neo4j.token.api.TokenNotFoundException;

public class NonTransactionalTokenNameLookup
implements TokenNameLookup {
    private final TokenHolders tokenHolders;
    private final boolean includeId;

    public NonTransactionalTokenNameLookup(TokenHolders tokenHolders) {
        this(tokenHolders, false);
    }

    public NonTransactionalTokenNameLookup(TokenHolders tokenHolders, boolean includeId) {
        this.tokenHolders = tokenHolders;
        this.includeId = includeId;
    }

    public String labelGetName(int labelId) {
        return this.tokenById(this.tokenHolders.labelTokens(), labelId, "label");
    }

    public String relationshipTypeGetName(int relTypeId) {
        return this.tokenById(this.tokenHolders.relationshipTypeTokens(), relTypeId, "relationshipType");
    }

    public String propertyKeyGetName(int propertyKeyId) {
        return this.tokenById(this.tokenHolders.propertyKeyTokens(), propertyKeyId, "property");
    }

    private String tokenById(TokenHolder tokenHolder, int tokenId, String tokenType) {
        try {
            String tokenName = tokenHolder.getTokenById(tokenId).name();
            return this.includeId ? NonTransactionalTokenNameLookup.nameAndId(tokenId, tokenName) : tokenName;
        }
        catch (TokenNotFoundException tokenNotFoundException) {
            return NonTransactionalTokenNameLookup.nameAndId(tokenId, tokenType);
        }
    }

    private static String nameAndId(int id, String name) {
        return String.format("%s[%d]", name, id);
    }
}

