/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.tuple.Pair;
import org.neo4j.common.EntityType;
import org.neo4j.internal.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.ConstraintType;
import org.neo4j.internal.schema.EndpointType;
import org.neo4j.internal.schema.GraphTypeDependence;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.NodeLabelExistenceSchemaDescriptor;
import org.neo4j.internal.schema.RelationshipEndpointLabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorImplementationNode;
import org.neo4j.internal.schema.SchemaPatternMatchingType;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.internal.schema.SchemaValueTypes;
import org.neo4j.internal.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.internal.schema.constraints.IndexBackedConstraintDescriptor;
import org.neo4j.internal.schema.constraints.KeyConstraintDescriptor;
import org.neo4j.internal.schema.constraints.NodeLabelExistenceConstraintDescriptor;
import org.neo4j.internal.schema.constraints.PropertyTypeSet;
import org.neo4j.internal.schema.constraints.RelationshipEndpointLabelConstraintDescriptor;
import org.neo4j.internal.schema.constraints.SchemaValueType;
import org.neo4j.internal.schema.constraints.TypeConstraintDescriptor;
import org.neo4j.internal.schema.constraints.UniquenessConstraintDescriptor;
import org.neo4j.values.storable.IntArray;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.StringArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class SchemaRuleMapifier {
    private static final String PROP_SCHEMA_RULE_PREFIX = "__org.neo4j.SchemaRule.";
    private static final String PROP_SCHEMA_RULE_TYPE = "__org.neo4j.SchemaRule.schemaRuleType";
    private static final String PROP_INDEX_RULE_TYPE = "__org.neo4j.SchemaRule.indexRuleType";
    private static final String PROP_CONSTRAINT_RULE_TYPE = "__org.neo4j.SchemaRule.constraintRuleType";
    private static final String PROP_SCHEMA_GRAPH_TYPE_DEPENDENCE = "__org.neo4j.SchemaRule.graphTypeDependence";
    private static final String PROP_SCHEMA_ENDPOINT_TYPE = "__org.neo4j.SchemaRule.endpointType";
    private static final String PROP_SCHEMA_ENDPOINT_LABEL_ID = "__org.neo4j.SchemaRule.endpointLabelId";
    private static final String PROP_SCHEMA_NODE_LABEL_EXISTENCE_REQUIRED_LABEL_ID = "__org.neo4j.SchemaRule.requiredLabelId";
    private static final String PROP_SCHEMA_RULE_NAME = "__org.neo4j.SchemaRule.name";
    private static final String PROP_OWNED_INDEX = "__org.neo4j.SchemaRule.ownedIndex";
    public static final String PROP_OWNING_CONSTRAINT = "__org.neo4j.SchemaRule.owningConstraint";
    private static final String PROP_INDEX_PROVIDER_NAME = "__org.neo4j.SchemaRule.indexProviderName";
    private static final String PROP_INDEX_PROVIDER_VERSION = "__org.neo4j.SchemaRule.indexProviderVersion";
    private static final String PROP_SCHEMA_DESCRIPTOR_ENTITY_TYPE = "__org.neo4j.SchemaRule.schemaEntityType";
    private static final String PROP_SCHEMA_DESCRIPTOR_ENTITY_IDS = "__org.neo4j.SchemaRule.schemaEntityIds";
    private static final String PROP_SCHEMA_DESCRIPTOR_PROPERTY_IDS = "__org.neo4j.SchemaRule.schemaPropertyIds";
    private static final String PROP_SCHEMA_DESCRIPTOR_SCHEMA_PATTERN_MATCHING_TYPE = "__org.neo4j.SchemaRule.schemaPropertySchemaType";
    private static final String PROP_INDEX_TYPE = "__org.neo4j.SchemaRule.indexType";
    private static final String PROP_CONSTRAINT_ALLOWED_TYPES = "__org.neo4j.SchemaRule.propertyType";
    private static final String PROP_INDEX_CONFIG_PREFIX = "__org.neo4j.SchemaRule.IndexConfig.";

    public static Map<String, Value> mapifySchemaRule(SchemaRule rule) {
        HashMap<String, Value> map = new HashMap<String, Value>();
        SchemaRuleMapifier.putStringProperty(map, PROP_SCHEMA_RULE_NAME, rule.getName());
        SchemaRuleMapifier.schemaDescriptorToMap(rule.schema(), map);
        if (rule instanceof IndexDescriptor) {
            IndexDescriptor index = (IndexDescriptor)rule;
            SchemaRuleMapifier.schemaIndexToMap(index, map);
        } else if (rule instanceof ConstraintDescriptor) {
            ConstraintDescriptor constraint = (ConstraintDescriptor)rule;
            SchemaRuleMapifier.schemaConstraintToMap(constraint, map);
        }
        return map;
    }

    public static SchemaRule unmapifySchemaRule(long ruleId, Map<String, Value> map) throws MalformedSchemaRuleException {
        String schemaRuleType;
        return switch (schemaRuleType = SchemaRuleMapifier.getString(PROP_SCHEMA_RULE_TYPE, map)) {
            case "INDEX" -> SchemaRuleMapifier.buildIndexRule(ruleId, map);
            case "CONSTRAINT" -> SchemaRuleMapifier.buildConstraintRule(ruleId, map);
            default -> throw new MalformedSchemaRuleException("Can not create a schema rule of type: " + schemaRuleType);
        };
    }

    private static void schemaDescriptorToMap(SchemaDescriptor schemaDescriptor, Map<String, Value> map) {
        EntityType entityType = schemaDescriptor.entityType();
        SchemaPatternMatchingType schemaPatternMatchingType = schemaDescriptor.schemaPatternMatchingType();
        int[] entityTokenIds = schemaDescriptor.getEntityTokenIds();
        int[] propertyIds = schemaDescriptor.getPropertyIds();
        SchemaRuleMapifier.putStringProperty(map, PROP_SCHEMA_DESCRIPTOR_ENTITY_TYPE, entityType.name());
        SchemaRuleMapifier.putStringProperty(map, PROP_SCHEMA_DESCRIPTOR_SCHEMA_PATTERN_MATCHING_TYPE, schemaPatternMatchingType.name());
        SchemaRuleMapifier.putIntArrayProperty(map, PROP_SCHEMA_DESCRIPTOR_ENTITY_IDS, entityTokenIds);
        SchemaRuleMapifier.putIntArrayProperty(map, PROP_SCHEMA_DESCRIPTOR_PROPERTY_IDS, propertyIds);
    }

    private static void indexConfigToMap(IndexConfig indexConfig, Map<String, Value> map) {
        RichIterable entries = indexConfig.entries();
        for (Pair entry : entries) {
            SchemaRuleMapifier.putIndexConfigProperty(map, (String)entry.getOne(), (Value)entry.getTwo());
        }
    }

    private static void schemaIndexToMap(IndexDescriptor rule, Map<String, Value> map) {
        SchemaRuleMapifier.putStringProperty(map, PROP_SCHEMA_RULE_TYPE, "INDEX");
        IndexType indexType = rule.getIndexType();
        SchemaRuleMapifier.putStringProperty(map, PROP_INDEX_TYPE, indexType.name());
        if (rule.isUnique()) {
            SchemaRuleMapifier.putStringProperty(map, PROP_INDEX_RULE_TYPE, "UNIQUE");
            if (rule.getOwningConstraintId().isPresent()) {
                map.put(PROP_OWNING_CONSTRAINT, (Value)Values.longValue((long)rule.getOwningConstraintId().getAsLong()));
            }
        } else {
            SchemaRuleMapifier.putStringProperty(map, PROP_INDEX_RULE_TYPE, "NON_UNIQUE");
        }
        SchemaRuleMapifier.indexProviderToMap(rule, map);
        IndexConfig indexConfig = rule.getIndexConfig();
        SchemaRuleMapifier.indexConfigToMap(indexConfig, map);
    }

    private static void indexProviderToMap(IndexDescriptor rule, Map<String, Value> map) {
        IndexProviderDescriptor provider = rule.getIndexProvider();
        String name = provider.getKey();
        String version = provider.getVersion();
        SchemaRuleMapifier.putStringProperty(map, PROP_INDEX_PROVIDER_NAME, name);
        SchemaRuleMapifier.putStringProperty(map, PROP_INDEX_PROVIDER_VERSION, version);
    }

    private static void schemaConstraintToMap(ConstraintDescriptor rule, Map<String, Value> map) {
        ConstraintType type = rule.type();
        SchemaRuleMapifier.putStringProperty(map, PROP_SCHEMA_RULE_TYPE, "CONSTRAINT");
        SchemaRuleMapifier.putStringProperty(map, PROP_CONSTRAINT_RULE_TYPE, type.name());
        SchemaRuleMapifier.putStringProperty(map, PROP_SCHEMA_GRAPH_TYPE_DEPENDENCE, rule.graphTypeDependence().name());
        switch (type) {
            case UNIQUE: 
            case UNIQUE_EXISTS: {
                IndexBackedConstraintDescriptor indexBackedConstraint = rule.asIndexBackedConstraint();
                SchemaRuleMapifier.putStringProperty(map, PROP_INDEX_TYPE, indexBackedConstraint.indexType().name());
                if (!indexBackedConstraint.hasOwnedIndexId()) break;
                SchemaRuleMapifier.putLongProperty(map, PROP_OWNED_INDEX, indexBackedConstraint.ownedIndexId());
                break;
            }
            case PROPERTY_TYPE: {
                TypeConstraintDescriptor typeConstraintDescriptor = rule.asPropertyTypeConstraint();
                PropertyTypeSet schemaValueTypes = typeConstraintDescriptor.propertyType();
                String[] typeArray = new String[schemaValueTypes.size()];
                int i = 0;
                for (SchemaValueType schemaValueType : schemaValueTypes) {
                    typeArray[i++] = schemaValueType.serialize();
                }
                SchemaRuleMapifier.putStringArrayProperty(map, PROP_CONSTRAINT_ALLOWED_TYPES, typeArray);
                break;
            }
            case RELATIONSHIP_ENDPOINT_LABEL: {
                RelationshipEndpointLabelConstraintDescriptor relationshipEndpointLabelConstraintDescriptor = rule.asRelationshipEndpointLabelConstraint();
                SchemaRuleMapifier.putStringProperty(map, PROP_SCHEMA_ENDPOINT_TYPE, relationshipEndpointLabelConstraintDescriptor.endpointType().name());
                SchemaRuleMapifier.putLongProperty(map, PROP_SCHEMA_ENDPOINT_LABEL_ID, relationshipEndpointLabelConstraintDescriptor.endpointLabelId());
                break;
            }
            case NODE_LABEL_EXISTENCE: {
                NodeLabelExistenceConstraintDescriptor nodeLabelExistenceConstraintDescriptor = rule.asNodeLabelExistenceConstraint();
                SchemaRuleMapifier.putLongProperty(map, PROP_SCHEMA_NODE_LABEL_EXISTENCE_REQUIRED_LABEL_ID, nodeLabelExistenceConstraintDescriptor.requiredLabelId());
                break;
            }
        }
    }

    private static int[] getIntArray(String property, Map<String, Value> props) throws MalformedSchemaRuleException {
        Value value = props.get(property);
        if (value instanceof IntArray) {
            IntArray intArray = (IntArray)value;
            return intArray.asObject();
        }
        throw new MalformedSchemaRuleException("Expected property " + property + " to be a IntArray but was " + value);
    }

    private static long getLong(String property, Map<String, Value> props) throws MalformedSchemaRuleException {
        Value value = props.get(property);
        if (value instanceof LongValue) {
            LongValue longValue = (LongValue)value;
            return longValue.value();
        }
        throw new MalformedSchemaRuleException("Expected property " + property + " to be a LongValue but was " + value);
    }

    private static OptionalLong getOptionalLong(String property, Map<String, Value> props) {
        Value value = props.get(property);
        if (value instanceof LongValue) {
            LongValue longValue = (LongValue)value;
            return OptionalLong.of(longValue.value());
        }
        return OptionalLong.empty();
    }

    private static Optional<String> getOptionalString(String property, Map<String, Value> map) {
        Value value = map.get(property);
        if (value instanceof TextValue) {
            TextValue textValue = (TextValue)value;
            return Optional.of(textValue.stringValue());
        }
        return Optional.empty();
    }

    private static String getString(String property, Map<String, Value> map) throws MalformedSchemaRuleException {
        Value value = map.get(property);
        if (value instanceof TextValue) {
            TextValue textValue = (TextValue)value;
            return textValue.stringValue();
        }
        throw new MalformedSchemaRuleException("Expected property " + property + " to be a TextValue but was " + value);
    }

    private static String[] getStringArray(String property, Map<String, Value> props) throws MalformedSchemaRuleException {
        Value value = props.get(property);
        if (value instanceof StringArray) {
            StringArray stringArray = (StringArray)value;
            return stringArray.asObject();
        }
        throw new MalformedSchemaRuleException("Expected property " + property + " to be a StringArray but was " + value);
    }

    private static void putLongProperty(Map<String, Value> map, String property, long value) {
        map.put(property, (Value)Values.longValue((long)value));
    }

    private static void putIntArrayProperty(Map<String, Value> map, String property, int[] value) {
        map.put(property, (Value)Values.intArray((int[])value));
    }

    private static void putStringProperty(Map<String, Value> map, String property, String value) {
        map.put(property, (Value)Values.stringValue((String)value));
    }

    private static void putStringArrayProperty(Map<String, Value> map, String property, String[] value) {
        map.put(property, (Value)Values.stringArray((String[])value));
    }

    private static void putIndexConfigProperty(Map<String, Value> map, String key, Value value) {
        map.put(PROP_INDEX_CONFIG_PREFIX + key, value);
    }

    private static SchemaRule buildIndexRule(long schemaRuleId, Map<String, Value> props) throws MalformedSchemaRuleException {
        SchemaDescriptor schema = SchemaRuleMapifier.buildSchemaDescriptor(props);
        String indexRuleType = SchemaRuleMapifier.getString(PROP_INDEX_RULE_TYPE, props);
        boolean unique = SchemaRuleMapifier.parseIndexType(indexRuleType);
        IndexPrototype prototype = unique ? IndexPrototype.uniqueForSchema((SchemaDescriptor)schema) : IndexPrototype.forSchema((SchemaDescriptor)schema);
        prototype = prototype.withName(SchemaRuleMapifier.getString(PROP_SCHEMA_RULE_NAME, props));
        prototype = prototype.withIndexType(SchemaRuleMapifier.getIndexType(SchemaRuleMapifier.getString(PROP_INDEX_TYPE, props)));
        String providerKey = SchemaRuleMapifier.getString(PROP_INDEX_PROVIDER_NAME, props);
        String providerVersion = SchemaRuleMapifier.getString(PROP_INDEX_PROVIDER_VERSION, props);
        IndexProviderDescriptor providerDescriptor = new IndexProviderDescriptor(providerKey, providerVersion);
        prototype = prototype.withIndexProvider(providerDescriptor);
        IndexDescriptor index = prototype.materialise(schemaRuleId);
        IndexConfig indexConfig = SchemaRuleMapifier.extractIndexConfig(props);
        index = index.withIndexConfig(indexConfig);
        if (props.containsKey(PROP_OWNING_CONSTRAINT)) {
            index = index.withOwningConstraintId(SchemaRuleMapifier.getLong(PROP_OWNING_CONSTRAINT, props));
        }
        return index;
    }

    private static boolean parseIndexType(String indexRuleType) throws MalformedSchemaRuleException {
        return switch (indexRuleType) {
            case "NON_UNIQUE" -> false;
            case "UNIQUE" -> true;
            default -> throw new MalformedSchemaRuleException("Did not recognize index rule type: " + indexRuleType);
        };
    }

    private static SchemaRule buildConstraintRule(long id, Map<String, Value> props) throws MalformedSchemaRuleException {
        SchemaDescriptor schema = SchemaRuleMapifier.buildSchemaDescriptor(props);
        ConstraintType constraintRuleType = SchemaRuleMapifier.getConstraintType(SchemaRuleMapifier.getString(PROP_CONSTRAINT_RULE_TYPE, props));
        GraphTypeDependence graphTypeDependence = SchemaRuleMapifier.getGraphTypeDependence(constraintRuleType, SchemaRuleMapifier.getOptionalString(PROP_SCHEMA_GRAPH_TYPE_DEPENDENCE, props));
        String name = SchemaRuleMapifier.getString(PROP_SCHEMA_RULE_NAME, props);
        OptionalLong ownedIndex = SchemaRuleMapifier.getOptionalLong(PROP_OWNED_INDEX, props);
        ConstraintDescriptor constraint = SchemaRuleMapifier.getConstraintDescriptor(constraintRuleType, graphTypeDependence, schema, ownedIndex, props);
        return constraint.withId(id).withName(name);
    }

    private static ConstraintDescriptor getConstraintDescriptor(ConstraintType constraintRuleType, GraphTypeDependence graphTypeDependence, SchemaDescriptor schema, OptionalLong ownedIndex, Map<String, Value> props) throws MalformedSchemaRuleException {
        return switch (constraintRuleType) {
            default -> throw new IncompatibleClassChangeError();
            case ConstraintType.UNIQUE -> {
                UniquenessConstraintDescriptor constraint = ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)schema, (IndexType)SchemaRuleMapifier.getIndexType(SchemaRuleMapifier.getString(PROP_INDEX_TYPE, props)));
                if (ownedIndex.isPresent()) {
                    constraint = constraint.withOwnedIndexId(ownedIndex.getAsLong());
                }
                yield constraint;
            }
            case ConstraintType.EXISTS -> ConstraintDescriptorFactory.existsForSchema((SchemaDescriptor)schema, (graphTypeDependence == GraphTypeDependence.DEPENDENT ? 1 : 0) != 0);
            case ConstraintType.UNIQUE_EXISTS -> {
                KeyConstraintDescriptor constraint = ConstraintDescriptorFactory.keyForSchema((SchemaDescriptor)schema, (IndexType)SchemaRuleMapifier.getIndexType(SchemaRuleMapifier.getString(PROP_INDEX_TYPE, props)));
                if (ownedIndex.isPresent()) {
                    constraint = constraint.withOwnedIndexId(ownedIndex.getAsLong());
                }
                yield constraint;
            }
            case ConstraintType.PROPERTY_TYPE -> ConstraintDescriptorFactory.typeForSchema((SchemaDescriptor)schema, (PropertyTypeSet)SchemaRuleMapifier.getAllowedTypes(SchemaRuleMapifier.getStringArray(PROP_CONSTRAINT_ALLOWED_TYPES, props)), (graphTypeDependence == GraphTypeDependence.DEPENDENT ? 1 : 0) != 0);
            case ConstraintType.RELATIONSHIP_ENDPOINT_LABEL -> ConstraintDescriptorFactory.relationshipEndpointLabelForSchema((RelationshipEndpointLabelSchemaDescriptor)((RelationshipEndpointLabelSchemaDescriptor)schema.asSchemaDescriptorType(RelationshipEndpointLabelSchemaDescriptor.class)), (int)((int)SchemaRuleMapifier.getLong(PROP_SCHEMA_ENDPOINT_LABEL_ID, props)), (EndpointType)SchemaRuleMapifier.getEndpointType(props));
            case ConstraintType.NODE_LABEL_EXISTENCE -> ConstraintDescriptorFactory.nodeLabelExistenceForSchema((NodeLabelExistenceSchemaDescriptor)((NodeLabelExistenceSchemaDescriptor)schema.asSchemaDescriptorType(NodeLabelExistenceSchemaDescriptor.class)), (int)((int)SchemaRuleMapifier.getLong(PROP_SCHEMA_NODE_LABEL_EXISTENCE_REQUIRED_LABEL_ID, props)));
        };
    }

    private static SchemaDescriptor buildSchemaDescriptor(Map<String, Value> props) throws MalformedSchemaRuleException {
        EntityType entityType = SchemaRuleMapifier.getEntityType(SchemaRuleMapifier.getString(PROP_SCHEMA_DESCRIPTOR_ENTITY_TYPE, props));
        SchemaPatternMatchingType schemaPatternMatchingType = SchemaRuleMapifier.getSchemaPatternMatchingType(SchemaRuleMapifier.getString(PROP_SCHEMA_DESCRIPTOR_SCHEMA_PATTERN_MATCHING_TYPE, props));
        int[] entityIds = SchemaRuleMapifier.getIntArray(PROP_SCHEMA_DESCRIPTOR_ENTITY_IDS, props);
        int[] propertyIds = SchemaRuleMapifier.getIntArray(PROP_SCHEMA_DESCRIPTOR_PROPERTY_IDS, props);
        return new SchemaDescriptorImplementationNode(entityType, schemaPatternMatchingType, entityIds, propertyIds);
    }

    private static IndexConfig extractIndexConfig(Map<String, Value> props) {
        HashMap<String, Value> configMap = new HashMap<String, Value>();
        for (Map.Entry<String, Value> entry : props.entrySet()) {
            if (!entry.getKey().startsWith(PROP_INDEX_CONFIG_PREFIX)) continue;
            configMap.put(entry.getKey().substring(PROP_INDEX_CONFIG_PREFIX.length()), entry.getValue());
        }
        return IndexConfig.with(configMap);
    }

    private static IndexType getIndexType(String indexType) throws MalformedSchemaRuleException {
        try {
            return IndexType.valueOf((String)indexType);
        }
        catch (Exception e) {
            throw new MalformedSchemaRuleException("Did not recognize index type: " + indexType, (Throwable)e);
        }
    }

    private static SchemaPatternMatchingType getSchemaPatternMatchingType(String schemaPatternMatchingType) throws MalformedSchemaRuleException {
        try {
            return SchemaPatternMatchingType.valueOf((String)schemaPatternMatchingType);
        }
        catch (Exception e) {
            throw new MalformedSchemaRuleException("Did not recognize schema pattern matching type: " + schemaPatternMatchingType, (Throwable)e);
        }
    }

    private static EntityType getEntityType(String entityType) throws MalformedSchemaRuleException {
        try {
            return EntityType.valueOf((String)entityType);
        }
        catch (Exception e) {
            throw new MalformedSchemaRuleException("Did not recognize entity type: " + entityType, (Throwable)e);
        }
    }

    private static PropertyTypeSet getAllowedTypes(String[] allowedTypes) throws MalformedSchemaRuleException {
        ArrayList<SchemaValueType> types = new ArrayList<SchemaValueType>();
        for (String allowedType : allowedTypes) {
            try {
                types.add(SchemaValueTypes.convertToSchemaValueType((String)allowedType));
            }
            catch (Exception e) {
                throw new MalformedSchemaRuleException("Did not recognize schema value type '%s' in: %s".formatted(allowedType, Arrays.toString(allowedTypes)), (Throwable)e);
            }
        }
        return PropertyTypeSet.of(types);
    }

    static GraphTypeDependence getGraphTypeDependence(ConstraintType constraintType, Optional<String> maybeGraphTypeDependence) throws MalformedSchemaRuleException {
        if (maybeGraphTypeDependence.isPresent()) {
            GraphTypeDependence graphTypeDependence;
            try {
                graphTypeDependence = GraphTypeDependence.valueOf((String)maybeGraphTypeDependence.get());
            }
            catch (Exception e) {
                throw new MalformedSchemaRuleException("Did not recognize constraint dependency type: " + maybeGraphTypeDependence.get(), (Throwable)e);
            }
            if (constraintType.enforcesUniqueness() && graphTypeDependence != GraphTypeDependence.UNDESIGNATED) {
                throw new MalformedSchemaRuleException("incompatible graph type dependence " + graphTypeDependence + " with constraint rule type " + constraintType);
            }
            return graphTypeDependence;
        }
        return constraintType.enforcesUniqueness() ? GraphTypeDependence.UNDESIGNATED : GraphTypeDependence.INDEPENDENT;
    }

    static EndpointType getEndpointType(Map<String, Value> props) throws MalformedSchemaRuleException {
        Optional<String> maybeEndpointType = SchemaRuleMapifier.getOptionalString(PROP_SCHEMA_ENDPOINT_TYPE, props);
        if (maybeEndpointType.isPresent()) {
            String enumName = maybeEndpointType.get();
            try {
                return EndpointType.valueOf((String)enumName);
            }
            catch (IllegalArgumentException e) {
                throw new MalformedSchemaRuleException("Endpoint type with name " + enumName + " not recognized");
            }
        }
        throw new MalformedSchemaRuleException("Endpoint type of endpoint label constraint not found");
    }

    static ConstraintType getConstraintType(String constraintType) throws MalformedSchemaRuleException {
        try {
            return ConstraintType.valueOf((String)constraintType);
        }
        catch (Exception e) {
            throw new MalformedSchemaRuleException("Did not recognize constraint rule type: " + constraintType);
        }
    }
}

