/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Path;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.storemigration.ExistingTargetStrategy;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum FileOperation {
    COPY{

        @Override
        public void perform(FileSystemAbstraction fs, String fileName, Path fromDirectory, boolean skipNonExistentFromFile, Path toDirectory, ExistingTargetStrategy existingTargetStrategy) throws IOException {
            Path toFile;
            Path fromFile = FileOperation.fromFile(fs, fromDirectory, fileName, skipNonExistentFromFile);
            if (fromFile != null && (toFile = FileOperation.toFile(fs, toDirectory, fileName, existingTargetStrategy)) != null) {
                fs.copyFile(fromFile, toFile);
            }
        }
    }
    ,
    MOVE{

        @Override
        public void perform(FileSystemAbstraction fs, String fileName, Path fromDirectory, boolean skipNonExistentFromFile, Path toDirectory, ExistingTargetStrategy existingTargetStrategy) throws IOException {
            Path fromFile = FileOperation.fromFile(fs, fromDirectory, fileName, skipNonExistentFromFile);
            if (fromFile != null && FileOperation.toFile(fs, toDirectory, fileName, existingTargetStrategy) != null) {
                fs.moveToDirectory(fromFile, toDirectory);
            }
        }
    }
    ,
    DELETE{

        @Override
        public void perform(FileSystemAbstraction fs, String fileName, Path directory, boolean skipNonExistentFromFile, Path unusedFile, ExistingTargetStrategy unused) throws IOException {
            Path file = FileOperation.fromFile(fs, directory, fileName, skipNonExistentFromFile);
            if (file != null) {
                fs.deleteFile(file);
            }
        }
    }
    ,
    DELETE_INCLUDING_DIRS{

        @Override
        public void perform(FileSystemAbstraction fs, String fileName, Path directory, boolean skipNonExistentFromFile, Path unusedFile, ExistingTargetStrategy unused) throws IOException {
            Path file = FileOperation.fromFile(fs, directory, fileName, skipNonExistentFromFile);
            if (file != null) {
                if (fs.isDirectory(file)) {
                    fs.deleteRecursively(file);
                } else {
                    fs.deleteFile(file);
                }
            }
        }
    };


    public abstract void perform(FileSystemAbstraction var1, String var2, Path var3, boolean var4, Path var5, ExistingTargetStrategy var6) throws IOException;

    private static Path fromFile(FileSystemAbstraction fs, Path directory, String name, boolean skipNonExistent) {
        Path fromFile = directory.resolve(name);
        if (skipNonExistent && !fs.fileExists(fromFile)) {
            return null;
        }
        return fromFile;
    }

    private static Path toFile(FileSystemAbstraction fs, Path directory, String name, ExistingTargetStrategy existingTargetStrategy) throws IOException {
        Path file = directory.resolve(name);
        if (fs.fileExists(file)) {
            switch (existingTargetStrategy) {
                case FAIL: {
                    throw new FileAlreadyExistsException(file.toAbsolutePath().toString());
                }
                case OVERWRITE: {
                    fs.deleteFile(file);
                    return file;
                }
                case SKIP: {
                    return null;
                }
            }
            throw new IllegalStateException(existingTargetStrategy.name());
        }
        return file;
    }
}

