/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema;

import java.util.Iterator;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.neo4j.common.EntityType;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaCache;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.storageengine.api.StorageSchemaReader;

public class StorageSchemaReaderSnapshot
implements StorageSchemaReader {
    private final SchemaCache schema;

    public StorageSchemaReaderSnapshot(SchemaCache schema) {
        this.schema = schema;
    }

    public boolean indexExists(IndexDescriptor index) {
        return this.schema.hasIndex(index);
    }

    public boolean constraintExists(ConstraintDescriptor constraint) {
        return this.schema.hasConstraintRule(constraint);
    }

    public IndexDescriptor indexGetForName(String name) {
        return this.schema.indexForName(name);
    }

    public ConstraintDescriptor constraintGetForName(String name) {
        return this.schema.constraintForName(name);
    }

    public Iterator<IndexDescriptor> indexGetForSchema(SchemaDescriptor descriptor) {
        return this.schema.indexesForSchema(descriptor);
    }

    public IndexDescriptor indexGetForSchemaAndType(SchemaDescriptor descriptor, IndexType type) {
        return this.schema.indexForSchemaAndType(descriptor, type);
    }

    public Iterator<IndexDescriptor> indexesGetForLabel(int labelId) {
        return this.schema.indexesForLabel(labelId);
    }

    public Iterator<IndexDescriptor> indexesGetForRelationshipType(int relationshipType) {
        return this.schema.indexesForRelationshipType(relationshipType);
    }

    public Iterator<IndexDescriptor> indexesGetAll() {
        return this.schema.indexes().iterator();
    }

    public Iterator<ConstraintDescriptor> constraintsGetForLabel(int labelId) {
        return this.schema.constraintsForLabel(labelId);
    }

    public Iterator<ConstraintDescriptor> constraintsGetForRelationshipType(int typeId) {
        return this.schema.constraintsForRelationshipType(typeId);
    }

    public Iterator<ConstraintDescriptor> constraintsGetAll() {
        return this.schema.constraints().iterator();
    }

    public IntSet[] constraintsGetPropertyTokensForLogicalKey(int token, EntityType entityType) {
        return this.schema.constraintsGetPropertyTokensForLogicalKey(token, entityType);
    }
}

