/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.impl.iterator.ImmutableEmptyLongIterator;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.graphdb.Direction;
import org.neo4j.storageengine.api.RelationshipDirection;
import org.neo4j.storageengine.api.txstate.NodeState;
import org.neo4j.util.Preconditions;

public abstract class RelationshipSelection {
    public static final RelationshipSelection ALL_RELATIONSHIPS = new RelationshipSelection(){
        private final Criterion ALL_CRITERIA = new CriterionImpl(-1, Direction.BOTH);

        @Override
        public boolean test(int type) {
            return true;
        }

        @Override
        public boolean test(RelationshipDirection direction) {
            return true;
        }

        @Override
        public Direction direction() {
            return Direction.BOTH;
        }

        @Override
        public boolean test(int type, RelationshipDirection direction) {
            return true;
        }

        @Override
        public int numberOfCriteria() {
            return 1;
        }

        @Override
        public Criterion criterion(int index) {
            Preconditions.checkArgument((index == 0 ? 1 : 0) != 0, (String)"Unknown criterion index %d", (Object[])new Object[]{index});
            return this.ALL_CRITERIA;
        }

        @Override
        public boolean isTypeLimited() {
            return false;
        }

        @Override
        public boolean isLimited() {
            return false;
        }

        @Override
        public LongIterator addedRelationship(NodeState transactionState) {
            return transactionState.getAddedRelationships();
        }

        public String toString() {
            return "RelationshipSelection[*]";
        }
    };
    public static final RelationshipSelection NO_RELATIONSHIPS = new RelationshipSelection(){

        @Override
        public boolean test(int type) {
            return false;
        }

        @Override
        public boolean test(RelationshipDirection direction) {
            return false;
        }

        @Override
        public Direction direction() {
            return Direction.BOTH;
        }

        @Override
        public boolean test(int type, RelationshipDirection direction) {
            return false;
        }

        @Override
        public int numberOfCriteria() {
            return 0;
        }

        @Override
        public Criterion criterion(int index) {
            throw new IllegalArgumentException("Unknown criterion index " + index);
        }

        @Override
        public boolean isTypeLimited() {
            return true;
        }

        @Override
        public LongIterator addedRelationship(NodeState transactionState) {
            return ImmutableEmptyLongIterator.INSTANCE;
        }

        public String toString() {
            return "RelationshipSelection[NOTHING]";
        }
    };

    public abstract boolean test(int var1);

    public boolean test(int type, long sourceReference, long targetReference) {
        return this.test(type);
    }

    public abstract boolean test(RelationshipDirection var1);

    public abstract Direction direction();

    public abstract boolean test(int var1, RelationshipDirection var2);

    public abstract int numberOfCriteria();

    public abstract Criterion criterion(int var1);

    public abstract boolean isTypeLimited();

    public boolean isLimited() {
        return true;
    }

    public abstract LongIterator addedRelationship(NodeState var1);

    public static RelationshipSelection selection(int[] types, Direction direction) {
        if (types == null) {
            return RelationshipSelection.selection(direction);
        }
        if (types.length == 0) {
            return NO_RELATIONSHIPS;
        }
        if (types.length == 1) {
            return new DirectionalSingleType(types[0], direction);
        }
        return new DirectionalMultipleTypes(types, direction);
    }

    public static RelationshipSelection selection(int type, Direction direction) {
        return new DirectionalSingleType(type, direction);
    }

    public static RelationshipSelection selection(Direction direction) {
        return direction == Direction.BOTH ? ALL_RELATIONSHIPS : new DirectionalAllTypes(direction);
    }

    private static boolean matchesDirection(RelationshipDirection relationshipDirection, Direction selectionDirection) {
        switch (selectionDirection) {
            case OUTGOING: {
                return relationshipDirection == RelationshipDirection.OUTGOING || relationshipDirection == RelationshipDirection.LOOP;
            }
            case INCOMING: {
                return relationshipDirection == RelationshipDirection.INCOMING || relationshipDirection == RelationshipDirection.LOOP;
            }
            case BOTH: {
                return true;
            }
        }
        throw new UnsupportedOperationException(selectionDirection.name());
    }

    public static class CriterionImpl
    implements Criterion {
        private final int type;
        private final Direction direction;

        CriterionImpl(int type, Direction direction) {
            this.type = type;
            this.direction = direction;
        }

        @Override
        public int type() {
            return this.type;
        }

        @Override
        public Direction direction() {
            return this.direction;
        }
    }

    public static interface Criterion {
        public int type();

        public Direction direction();
    }

    private static class DirectionalAllTypes
    extends DirectionalSingleCriterion {
        DirectionalAllTypes(Direction direction) {
            super(-1, direction);
        }

        @Override
        public boolean test(int type) {
            return true;
        }

        @Override
        public boolean test(int type, RelationshipDirection direction) {
            return RelationshipSelection.matchesDirection(direction, this.direction);
        }

        @Override
        public boolean isTypeLimited() {
            return false;
        }

        @Override
        public LongIterator addedRelationship(NodeState transactionState) {
            return transactionState.getAddedRelationships(this.direction);
        }

        public String toString() {
            return "RelationshipSelection[" + this.direction + "]";
        }
    }

    private static class DirectionalMultipleTypes
    extends Directional {
        private final int[] types;

        DirectionalMultipleTypes(int[] types, Direction direction) {
            super(direction);
            this.types = types;
        }

        @Override
        public boolean test(int type) {
            return ArrayUtils.contains((int[])this.types, (int)type);
        }

        @Override
        public boolean test(int type, RelationshipDirection direction) {
            return this.test(type) && RelationshipSelection.matchesDirection(direction, this.direction);
        }

        @Override
        public int numberOfCriteria() {
            return this.types.length;
        }

        @Override
        public boolean isTypeLimited() {
            return true;
        }

        @Override
        public Criterion criterion(int index) {
            Preconditions.checkArgument((index < this.types.length ? 1 : 0) != 0, (String)"Unknown criterion index %d", (Object[])new Object[]{index});
            return new CriterionImpl(this.types[index], this.direction);
        }

        @Override
        public LongIterator addedRelationship(NodeState transactionState) {
            LongIterator[] all = new LongIterator[this.types.length];
            int index = 0;
            for (int i = 0; i < this.types.length; ++i) {
                if (DirectionalMultipleTypes.existsEarlier(this.types, i)) continue;
                all[index++] = transactionState.getAddedRelationships(this.direction, this.types[i]);
            }
            if (index != this.types.length) {
                all = Arrays.copyOf(all, index);
            }
            return PrimitiveLongCollections.concat((LongIterator[])all);
        }

        public String toString() {
            return "RelationshipSelection[types=" + Arrays.toString(this.types) + ", " + this.direction + "]";
        }

        private static boolean existsEarlier(int[] types, int i) {
            int candidateType = types[i];
            for (int j = i - 1; j >= 0; --j) {
                if (candidateType != types[j]) continue;
                return true;
            }
            return false;
        }
    }

    private static class DirectionalSingleType
    extends DirectionalSingleCriterion {
        DirectionalSingleType(int type, Direction direction) {
            super(type, direction);
        }

        @Override
        public boolean test(int type) {
            return this.type == type;
        }

        @Override
        public boolean test(int type, RelationshipDirection direction) {
            return this.type == type && RelationshipSelection.matchesDirection(direction, this.direction);
        }

        @Override
        public boolean isTypeLimited() {
            return true;
        }

        @Override
        public LongIterator addedRelationship(NodeState transactionState) {
            return transactionState.getAddedRelationships(this.direction, this.type);
        }

        public String toString() {
            return "RelationshipSelection[type=" + this.type + ", " + this.direction + "]";
        }
    }

    private static abstract class DirectionalSingleCriterion
    extends Directional
    implements Criterion {
        protected final int type;

        DirectionalSingleCriterion(int type, Direction direction) {
            super(direction);
            this.type = type;
        }

        @Override
        public boolean test(RelationshipDirection direction) {
            return RelationshipSelection.matchesDirection(direction, this.direction);
        }

        @Override
        public int numberOfCriteria() {
            return 1;
        }

        @Override
        public Criterion criterion(int index) {
            Preconditions.checkArgument((index == 0 ? 1 : 0) != 0, (String)"Unknown criterion index %d", (Object[])new Object[]{index});
            return this;
        }

        @Override
        public int type() {
            return this.type;
        }

        @Override
        public Direction direction() {
            return this.direction;
        }
    }

    private static abstract class Directional
    extends RelationshipSelection {
        protected final Direction direction;

        Directional(Direction direction) {
            this.direction = direction;
        }

        @Override
        public boolean test(RelationshipDirection direction) {
            return RelationshipSelection.matchesDirection(direction, this.direction);
        }

        @Override
        public Direction direction() {
            return this.direction;
        }
    }
}

