/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.impl;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.neo4j.helpers.Service;
import org.neo4j.shell.App;
import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.AppShellServer;
import org.neo4j.shell.Continuation;
import org.neo4j.shell.Output;
import org.neo4j.shell.Response;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.TabCompletion;
import org.neo4j.shell.TextUtil;
import org.neo4j.shell.impl.AbstractApp;
import org.neo4j.shell.impl.SimpleAppServer;

public abstract class AbstractAppServer
extends SimpleAppServer
implements AppShellServer {
    private final Map<String, App> apps = new TreeMap<String, App>();

    public AbstractAppServer() throws RemoteException {
        this(true);
    }

    public AbstractAppServer(boolean addFromServiceLoading) throws RemoteException {
        if (addFromServiceLoading) {
            for (App app : Service.load(App.class)) {
                this.addApp(app);
            }
        }
    }

    protected void addApp(App app) {
        this.apps.put(app.getName(), app);
        try {
            ((AbstractApp)app).setServer(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public App findApp(String command) {
        return this.apps.get(command);
    }

    @Override
    public void shutdown() throws RemoteException {
        for (App app : this.apps.values()) {
            app.shutdown();
        }
        super.shutdown();
    }

    @Override
    public Response interpretLine(Serializable clientId, String line, Output out) throws ShellException {
        Session session = this.getClientSession(clientId);
        if (line == null || line.trim().length() == 0) {
            return new Response(this.getPrompt(session), Continuation.INPUT_COMPLETE);
        }
        try {
            Continuation commandResult = null;
            for (String command : line.split(Pattern.quote("&&"))) {
                command = TextUtil.removeSpaces(command);
                command = this.replaceAlias(command, session);
                AppCommandParser parser = new AppCommandParser(this, command);
                commandResult = parser.app().execute(parser, session, out);
            }
            return new Response(this.getPrompt(session), commandResult);
        }
        catch (Exception e) {
            throw this.wrapException(e);
        }
    }

    protected String replaceAlias(String line, Session session) {
        boolean changed = true;
        HashSet<String> appNames = new HashSet<String>();
        while (changed) {
            changed = false;
            String appName = AppCommandParser.parseOutAppName(line);
            String alias = session.getAlias(appName);
            if (alias == null || !appNames.add(alias)) continue;
            changed = true;
            line = alias + line.substring(appName.length());
        }
        return line;
    }

    @Override
    public String[] getAllAvailableCommands() {
        return this.apps.keySet().toArray(new String[this.apps.size()]);
    }

    @Override
    public TabCompletion tabComplete(Serializable clientID, String partOfLine) throws ShellException, RemoteException {
        try {
            AppCommandParser parser = new AppCommandParser(this, partOfLine);
            App app = parser.app();
            List<String> appCandidates = app.completionCandidates(partOfLine, this.getClientSession(clientID));
            appCandidates = AbstractAppServer.quote(appCandidates);
            if (appCandidates.size() == 1) {
                appCandidates.set(0, appCandidates.get(0) + " ");
            }
            int cursor = partOfLine.length() - TextUtil.lastWordOrQuoteOf(partOfLine, true).length();
            return new TabCompletion(appCandidates, cursor);
        }
        catch (Exception e) {
            throw this.wrapException(e);
        }
    }

    protected ShellException wrapException(Exception e) {
        return ShellException.wrapCause(e);
    }

    private static List<String> quote(List<String> candidates) {
        ArrayList<String> result = new ArrayList<String>();
        for (String candidate : candidates) {
            candidate = candidate.replaceAll(" ", "\\\\ ");
            result.add(candidate);
        }
        return result;
    }
}

