/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.systemgraph;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventListenerAdapter;
import org.neo4j.kernel.database.DefaultDatabaseResolver;

public class CommunityDefaultDatabaseResolver
extends TransactionEventListenerAdapter<Object>
implements DefaultDatabaseResolver {
    private final Config config;
    private final Supplier<GraphDatabaseService> systemDbSupplier;
    private GraphDatabaseService systemDb;
    private final AtomicReference<String> cachedDefaultDatabase = new AtomicReference<Object>(null);

    public CommunityDefaultDatabaseResolver(Config config, Supplier<GraphDatabaseService> systemDbSupplier) {
        this.config = config;
        this.systemDbSupplier = systemDbSupplier;
    }

    public String defaultDatabase(String username) {
        String string;
        block10: {
            String cachedResult = this.cachedDefaultDatabase.get();
            if (cachedResult != null) {
                return cachedResult;
            }
            String defaultDatabase = this.getDefaultDatabase();
            Transaction tx = this.getSystemDb().beginTx();
            try {
                Node defaultDatabaseNode = tx.findNode(TopologyGraphDbmsModel.DATABASE_LABEL, "default", (Object)true);
                if (defaultDatabaseNode != null) {
                    defaultDatabase = (String)defaultDatabaseNode.getProperty("name", (Object)defaultDatabase);
                }
                tx.commit();
                this.cachedDefaultDatabase.set(defaultDatabase);
                string = defaultDatabase;
                if (tx == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (tx != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NotFoundException n) {
                    return defaultDatabase;
                }
            }
            tx.close();
        }
        return string;
    }

    public void clearCache() {
        this.cachedDefaultDatabase.set(null);
    }

    private GraphDatabaseService getSystemDb() {
        if (this.systemDb == null) {
            this.systemDb = this.systemDbSupplier.get();
        }
        return this.systemDb;
    }

    public String getDefaultDatabase() {
        return (String)this.config.get(GraphDatabaseSettings.initial_default_database);
    }

    public void afterCommit(TransactionData data, Object state, GraphDatabaseService databaseService) {
        this.clearCache();
    }
}

