/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.systemgraph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.server.security.systemgraph.KnownSystemComponentVersion;

public class KnownSystemComponentVersions<T extends KnownSystemComponentVersion> {
    public final T noSecurityGraph;
    private final ArrayList<T> knownComponentVersions = new ArrayList();

    public KnownSystemComponentVersions(T noSecurityGraph) {
        this.noSecurityGraph = noSecurityGraph;
    }

    public void add(T version) {
        this.knownComponentVersions.add(version);
    }

    public T detectCurrentSecurityGraphVersion(Transaction tx) {
        ArrayList<T> sortedVersions = new ArrayList<T>(this.knownComponentVersions);
        sortedVersions.sort(Comparator.comparingInt(v -> v.version));
        Collections.reverse(sortedVersions);
        for (KnownSystemComponentVersion version : sortedVersions) {
            if (!version.detected(tx)) continue;
            return (T)version;
        }
        return this.noSecurityGraph;
    }

    public T latestSecurityGraphVersion() {
        Object latest = this.noSecurityGraph;
        for (KnownSystemComponentVersion version : this.knownComponentVersions) {
            if (version.version <= ((KnownSystemComponentVersion)latest).version) continue;
            latest = version;
        }
        return latest;
    }

    public T findSecurityGraphVersion(String substring) {
        for (KnownSystemComponentVersion version : this.knownComponentVersions) {
            if (!version.description.equals(substring)) continue;
            return (T)version;
        }
        return this.noSecurityGraph;
    }
}

