/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.admin.security;

import java.io.File;
import java.io.IOException;
import org.neo4j.cli.AbstractCommand;
import org.neo4j.cli.CommandFailedException;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.ConfigUtils;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.security.Credential;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.security.auth.CommunitySecurityModule;
import org.neo4j.server.security.auth.FileUserRepository;
import org.neo4j.server.security.auth.LegacyCredential;
import org.neo4j.server.security.auth.ListSnapshot;
import org.neo4j.string.UTF8;
import org.neo4j.util.VisibleForTesting;
import picocli.CommandLine;

@CommandLine.Command(name="set-initial-password", description={"Sets the initial password of the initial admin user ('neo4j'). And removes the requirement to change password on first login."})
public class SetInitialPasswordCommand
extends AbstractCommand {
    @CommandLine.Option(names={"--require-password-change"}, defaultValue="false", description={"Require the user to change their password on first login."})
    private boolean changeRequired;
    @CommandLine.Parameters
    private String password;

    public SetInitialPasswordCommand(ExecutionContext ctx) {
        super(ctx);
    }

    public void execute() {
        Config config = this.loadNeo4jConfig();
        FileSystemAbstraction fileSystem = this.ctx.fs();
        if (this.realUsersExist(config)) {
            File authFile = CommunitySecurityModule.getUserRepositoryFile(config);
            throw new CommandFailedException(SetInitialPasswordCommand.realUsersExistErrorMsg(fileSystem, authFile));
        }
        File file = CommunitySecurityModule.getInitialUserRepositoryFile(config);
        if (fileSystem.fileExists(file)) {
            fileSystem.deleteFile(file);
        }
        FileUserRepository userRepository = new FileUserRepository(fileSystem, file, (LogProvider)NullLogProvider.getInstance());
        try {
            userRepository.start();
            userRepository.create(new User.Builder("neo4j", (Credential)LegacyCredential.forPassword(UTF8.encode((String)this.password))).withRequiredPasswordChange(this.changeRequired).build());
            userRepository.shutdown();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.ctx.out().println("Changed password for user 'neo4j'.");
    }

    private boolean realUsersExist(Config config) {
        boolean result = false;
        File authFile = CommunitySecurityModule.getUserRepositoryFile(config);
        if (this.ctx.fs().fileExists(authFile)) {
            result = true;
            FileUserRepository userRepository = new FileUserRepository(this.ctx.fs(), authFile, (LogProvider)NullLogProvider.getInstance());
            try (Lifespan life = new Lifespan(new Lifecycle[]{userRepository});){
                User user;
                ListSnapshot<User> users = userRepository.getPersistedSnapshot();
                if (users.values().size() == 1 && "neo4j".equals((user = users.values().get(0)).name()) && user.credentials().matchesPassword("neo4j")) {
                    result = false;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    private static String realUsersExistErrorMsg(FileSystemAbstraction fileSystem, File authFile) {
        File parentFile = authFile.getParentFile();
        File roles = new File(parentFile, "roles");
        String files = fileSystem.fileExists(roles) ? "`auth` and `roles` files" : "`auth` file";
        return "the provided initial password was not set because existing Neo4j users were detected at `" + authFile.getAbsolutePath() + "`. Please remove the existing " + files + " if you want to reset your database to only have a default user with the provided password.";
    }

    @VisibleForTesting
    Config loadNeo4jConfig() {
        Config cfg = Config.newBuilder().set(GraphDatabaseSettings.neo4j_home, (Object)this.ctx.homeDir().toAbsolutePath()).fromFileNoThrow(this.ctx.confDir().resolve("neo4j.conf")).build();
        ConfigUtils.disableAllConnectors((Config)cfg);
        return cfg;
    }
}

