/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.procedure.SystemProcedure;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class AuthProcedures {
    @Context
    public SecurityContext securityContext;
    @Context
    public Transaction transaction;
    @Context
    public GraphDatabaseAPI graph;
    private static List<String> changeRequiredList = List.of("password_change_required");

    @SystemProcedure
    @Deprecated
    @Description(value="Create a new user.")
    @Procedure(name="dbms.security.createUser", mode=Mode.DBMS, deprecatedBy="Administration command: CREATE USER")
    public void createUser(@Name(value="username") String username, @Name(value="password") String password, @Name(value="requirePasswordChange", defaultValue="true") boolean requirePasswordChange) throws ProcedureException {
        String query = String.format("CREATE USER %s SET PASSWORD '%s' %s", this.escapeParameter(username), password == null ? "" : password, requirePasswordChange ? "CHANGE REQUIRED" : "CHANGE NOT REQUIRED");
        this.runSystemCommand(query, "dbms.security.createUser");
    }

    @SystemProcedure
    @Deprecated
    @Description(value="Delete the specified user.")
    @Procedure(name="dbms.security.deleteUser", mode=Mode.DBMS, deprecatedBy="Administration command: DROP USER")
    public void deleteUser(@Name(value="username") String username) throws ProcedureException {
        String query = String.format("DROP USER %s", this.escapeParameter(username));
        this.runSystemCommand(query, "dbms.security.deleteUser");
    }

    @SystemProcedure
    @Deprecated
    @Description(value="Change the current user's password.")
    @Procedure(name="dbms.security.changePassword", mode=Mode.DBMS, deprecatedBy="Administration command: ALTER CURRENT USER SET PASSWORD")
    public void changePassword(@Name(value="password") String password) throws ProcedureException {
        throw new ProcedureException((Status)Status.Statement.FeatureDeprecationWarning, "This procedure is no longer available, use: 'ALTER CURRENT USER SET PASSWORD'", new Object[0]);
    }

    @SystemProcedure
    @Description(value="Show the current user.")
    @Procedure(name="dbms.showCurrentUser", mode=Mode.DBMS)
    public Stream<UserResult> showCurrentUser() {
        this.securityContext.assertCredentialsNotExpired();
        String username = this.securityContext.subject().username();
        return Stream.of(new UserResult(username, false));
    }

    @SystemProcedure
    @Deprecated
    @Description(value="List all native users.")
    @Procedure(name="dbms.security.listUsers", mode=Mode.DBMS, deprecatedBy="Administration command: SHOW USERS")
    public Stream<UserResult> listUsers() throws ProcedureException {
        String query = "SHOW USERS";
        ArrayList result = new ArrayList();
        try {
            Result execute = this.transaction.execute(query);
            execute.accept(row -> {
                String username = row.getString("user");
                Boolean changeRequired = row.getBoolean("passwordChangeRequired");
                result.add(new UserResult(username, changeRequired));
                return true;
            });
        }
        catch (Exception e) {
            this.translateException(e, "dbms.security.listUsers");
        }
        if (result.isEmpty()) {
            return this.showCurrentUser();
        }
        return result.stream();
    }

    private void runSystemCommand(String query, String procedureName) throws ProcedureException {
        try {
            Result execute = this.transaction.execute(query);
            execute.accept(row -> true);
        }
        catch (Exception e) {
            this.translateException(e, procedureName);
        }
    }

    private void translateException(Exception e, String procedureName) throws ProcedureException {
        Status status = Status.statusCodeOf((Throwable)e);
        if (status != null && status.equals(Status.Statement.NotSystemDatabaseError)) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, (Throwable)e, String.format("This is an administration command and it should be executed against the system database: %s", procedureName), new Object[0]);
        }
        throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, (Throwable)e, e.getMessage(), new Object[0]);
    }

    private String escapeParameter(String input) {
        return String.format("`%s`", input == null ? "" : input);
    }

    public static class UserResult {
        public final String username;
        public final List<String> roles = null;
        public final List<String> flags;

        UserResult(String username, boolean changeRequired) {
            this.username = username;
            this.flags = changeRequired ? changeRequiredList : Collections.emptyList();
        }
    }
}

