/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.systemgraph;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.cypher.internal.security.SecureHasher;
import org.neo4j.cypher.internal.security.SystemGraphCredential;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.dbms.database.SystemGraphInitializer;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.security.AuthProviderFailedException;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.impl.security.Credential;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.logging.Log;
import org.neo4j.server.security.auth.ListSnapshot;
import org.neo4j.server.security.auth.UserRepository;
import org.neo4j.server.security.systemgraph.SecurityGraphInitializer;
import org.neo4j.string.UTF8;

public class UserSecurityGraphInitializer
implements SecurityGraphInitializer {
    protected Label USER_LABEL = Label.label((String)"User");
    protected List<Node> userNodes = new ArrayList<Node>();
    protected List<String> usernames = new ArrayList<String>();
    protected final DatabaseManager<?> databaseManager;
    protected GraphDatabaseService systemDb;
    protected final SystemGraphInitializer systemGraphInitializer;
    protected Log log;
    protected final UserRepository migrationUserRepository;
    private final UserRepository initialUserRepository;
    private final SecureHasher secureHasher;

    public UserSecurityGraphInitializer(DatabaseManager<?> databaseManager, SystemGraphInitializer systemGraphInitializer, Log log, UserRepository migrationUserRepository, UserRepository initialUserRepository, SecureHasher secureHasher) {
        this.databaseManager = databaseManager;
        this.systemGraphInitializer = systemGraphInitializer;
        this.log = log;
        this.migrationUserRepository = migrationUserRepository;
        this.initialUserRepository = initialUserRepository;
        this.secureHasher = secureHasher;
    }

    @Override
    public void initializeSecurityGraph() throws Exception {
        this.initializeSecurityGraph(this.getSystemDb());
    }

    @Override
    public void initializeSecurityGraph(GraphDatabaseService database) throws Exception {
        this.systemGraphInitializer.initializeSystemGraph(database);
        this.systemDb = database;
        this.doInitializeSecurityGraph();
    }

    private void doInitializeSecurityGraph() throws Exception {
        this.setupConstraints();
        try (Transaction tx = this.systemDb.beginTx();){
            boolean initialUsersExist;
            this.userNodes = this.findInitialNodes(tx, this.USER_LABEL);
            this.userNodes.stream().filter(node -> node.hasProperty("name") && node.getProperty("name").getClass().equals(String.class)).forEach(node -> this.usernames.add((String)node.getProperty("name")));
            boolean bl = initialUsersExist = !this.userNodes.isEmpty();
            if (!initialUsersExist) {
                initialUsersExist = this.migrateFromAuthFile(tx);
            }
            if (!initialUsersExist) {
                this.addDefaultUser(tx);
            }
            this.setInitialPassword();
            tx.commit();
        }
    }

    private void setupConstraints() {
        try (Transaction tx = this.systemDb.beginTx();){
            block8: {
                try {
                    tx.schema().constraintFor(this.USER_LABEL).assertPropertyIsUnique("name").create();
                }
                catch (ConstraintViolationException e) {
                    if (e.getMessage().startsWith("An equivalent constraint already exists")) break block8;
                    throw e;
                }
            }
            tx.commit();
        }
    }

    protected ArrayList<Node> findInitialNodes(Transaction tx, Label label) {
        ArrayList<Node> nodeList = new ArrayList<Node>();
        ResourceIterator nodes = tx.findNodes(label);
        nodes.forEachRemaining(nodeList::add);
        nodes.close();
        return nodeList;
    }

    private boolean migrateFromAuthFile(Transaction tx) throws Exception {
        this.startUserRepository(this.migrationUserRepository);
        boolean migratedUsers = this.doMigrateUsers(tx, this.migrationUserRepository);
        this.stopUserRepository(this.migrationUserRepository);
        return migratedUsers;
    }

    protected boolean doMigrateUsers(Transaction tx, UserRepository userRepository) throws Exception {
        ListSnapshot<User> users = userRepository.getPersistedSnapshot();
        if (!users.values().isEmpty()) {
            for (User user : users.values()) {
                this.addUser(tx, user.name(), user.credentials(), user.passwordChangeRequired(), user.hasFlag("is_suspended"));
            }
            String userString = users.values().size() == 1 ? "user" : "users";
            this.log.info("Completed migration of %s %s into system graph.", new Object[]{Integer.toString(users.values().size()), userString});
            return true;
        }
        return false;
    }

    protected void addDefaultUser(Transaction tx) {
        SystemGraphCredential initialCredential = SystemGraphCredential.createCredentialForPassword((byte[])UTF8.encode((String)"neo4j"), (SecureHasher)this.secureHasher);
        this.addUser(tx, "neo4j", (Credential)initialCredential, true, false);
    }

    protected void startUserRepository(UserRepository userRepository) throws Exception {
        userRepository.init();
        userRepository.start();
    }

    protected void stopUserRepository(UserRepository userRepository) throws Exception {
        userRepository.stop();
        userRepository.shutdown();
    }

    protected void setInitialPassword() throws Exception {
        User initialUser;
        SystemGraphCredential credentials;
        Node defaultUser;
        if (this.userNodes.size() == 1 && (defaultUser = this.userNodes.get(0)).getProperty("name").equals("neo4j") && (credentials = SystemGraphCredential.deserialize((String)((String)defaultUser.getProperty("credentials")), (SecureHasher)this.secureHasher)).matchesPassword(UTF8.encode((String)"neo4j")) && (initialUser = this.getInitialUser()) != null) {
            defaultUser.setProperty("credentials", (Object)initialUser.credentials().serialize());
            defaultUser.setProperty("passwordChangeRequired", (Object)initialUser.passwordChangeRequired());
        }
    }

    private User getInitialUser() throws Exception {
        User initialUser = null;
        this.startUserRepository(this.initialUserRepository);
        if (this.initialUserRepository.numberOfUsers() == 1) {
            initialUser = this.initialUserRepository.getUserByName("neo4j");
            if (initialUser == null) {
                String errorMessage = "Invalid `auth.ini` file: the user in the file is not named neo4j";
                this.log.error(errorMessage);
                throw new IllegalStateException(errorMessage);
            }
        } else if (this.initialUserRepository.numberOfUsers() > 1) {
            String errorMessage = "Invalid `auth.ini` file: the file contains more than one user";
            this.log.error(errorMessage);
            throw new IllegalStateException(errorMessage);
        }
        this.stopUserRepository(this.initialUserRepository);
        return initialUser;
    }

    private void addUser(Transaction tx, String username, Credential credentials, boolean passwordChangeRequired, boolean suspended) {
        Node node = tx.createNode(new Label[]{this.USER_LABEL});
        node.setProperty("name", (Object)username);
        node.setProperty("credentials", (Object)credentials.serialize());
        node.setProperty("passwordChangeRequired", (Object)passwordChangeRequired);
        node.setProperty("suspended", (Object)suspended);
        this.userNodes.add(node);
        this.usernames.add(username);
    }

    protected GraphDatabaseService getSystemDb() {
        return ((DatabaseContext)this.databaseManager.getDatabaseContext(DatabaseIdRepository.NAMED_SYSTEM_DATABASE_ID).orElseThrow(() -> new AuthProviderFailedException("No database called `system` was found."))).databaseFacade();
    }
}

