/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.admin.security;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.arguments.Arguments;
import org.neo4j.dbms.DatabaseManagementSystemSettings;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Args;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.configuration.ConfigLoader;
import org.neo4j.server.security.auth.CommunitySecurityModule;
import org.neo4j.server.security.auth.Credential;
import org.neo4j.server.security.auth.FileUserRepository;
import org.neo4j.server.security.auth.User;

public class SetDefaultAdminCommand
implements AdminCommand {
    public static final String ADMIN_INI = "admin.ini";
    public static final String COMMAND_NAME = "set-default-admin";
    public static final Arguments arguments = new Arguments().withMandatoryPositionalArgument(0, "username");
    private final Path homeDir;
    private final Path configDir;
    private OutsideWorld outsideWorld;

    SetDefaultAdminCommand(Path homeDir, Path configDir, OutsideWorld outsideWorld) {
        this.homeDir = homeDir;
        this.configDir = configDir;
        this.outsideWorld = outsideWorld;
    }

    public void execute(String[] args) throws IncorrectUsage, CommandFailed {
        Args parsedArgs = this.validateArgs(args);
        try {
            this.setDefaultAdmin((String)parsedArgs.orphans().get(0));
        }
        catch (IncorrectUsage e) {
            throw e;
        }
        catch (Throwable throwable) {
            throw new CommandFailed("Failed to execute 'set-default-admin' command: " + throwable.getMessage(), (Exception)new RuntimeException(throwable));
        }
    }

    private Args validateArgs(String[] args) throws IncorrectUsage {
        Args parsedArgs = Args.parse((String[])args);
        if (parsedArgs.orphans().size() < 1) {
            throw new IncorrectUsage("No username specified.");
        }
        if (parsedArgs.orphans().size() > 1) {
            throw new IncorrectUsage("Too many arguments.");
        }
        return parsedArgs;
    }

    private void setDefaultAdmin(String username) throws Throwable {
        Config config = this.loadNeo4jConfig();
        File adminIniFile = new File(CommunitySecurityModule.getUserRepositoryFile(config).getParentFile(), ADMIN_INI);
        FileSystemAbstraction fileSystem = this.outsideWorld.fileSystem();
        if (fileSystem.fileExists(adminIniFile)) {
            fileSystem.deleteFile(adminIniFile);
        }
        FileUserRepository users = new FileUserRepository(fileSystem, adminIniFile, (LogProvider)NullLogProvider.getInstance());
        users.init();
        users.start();
        users.create(new User.Builder(username, Credential.INACCESSIBLE).build());
        users.stop();
        users.shutdown();
        this.outsideWorld.stdOutLine("Set default admin to '" + username + "'.");
    }

    Config loadNeo4jConfig() {
        ConfigLoader configLoader = new ConfigLoader(SetDefaultAdminCommand.settings());
        return configLoader.loadOfflineConfig(Optional.of(this.homeDir.toFile()), Optional.of(this.configDir.resolve("neo4j.conf").toFile()));
    }

    private static List<Class<?>> settings() {
        ArrayList settings = new ArrayList();
        settings.add(GraphDatabaseSettings.class);
        settings.add(DatabaseManagementSystemSettings.class);
        return settings;
    }

    public static class Provider
    extends AdminCommand.Provider {
        public Provider() {
            super(SetDefaultAdminCommand.COMMAND_NAME, new String[0]);
        }

        public Arguments allArguments() {
            return arguments;
        }

        public String description() {
            return "Sets the user to become admin if users but no roles are present, for example when upgrading to neo4j 3.1 enterprise.";
        }

        public String summary() {
            return "Sets the default admin user when no roles are present.";
        }

        public AdminCommand create(Path homeDir, Path configDir, OutsideWorld outsideWorld) {
            return new SetDefaultAdminCommand(homeDir, configDir, outsideWorld);
        }
    }
}

