/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.admin.security;

import java.io.File;
import java.nio.file.Path;
import java.time.Clock;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.dbms.DatabaseManagementSystemSettings;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Args;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.api.security.exception.InvalidArgumentsException;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.configuration.ConfigLoader;
import org.neo4j.server.security.auth.BasicAuthManager;
import org.neo4j.server.security.auth.BasicPasswordPolicy;
import org.neo4j.server.security.auth.FileUserRepository;
import org.neo4j.server.security.auth.PasswordPolicy;
import org.neo4j.server.security.auth.UserRepository;

public class SetPasswordCommand
implements AdminCommand {
    private final Path homeDir;
    private final Path configDir;
    private OutsideWorld outsideWorld;

    public SetPasswordCommand(Path homeDir, Path configDir, OutsideWorld outsideWorld) {
        this.homeDir = homeDir;
        this.configDir = configDir;
        this.outsideWorld = outsideWorld;
    }

    public void execute(String[] args) throws IncorrectUsage, CommandFailed {
        block7: {
            Args parsedArgs = Args.parse((String[])args);
            if (parsedArgs.orphans().size() < 2) {
                throw new IncorrectUsage("Missing arguments: expected username and password");
            }
            String username = (String)parsedArgs.orphans().get(0);
            String password = (String)parsedArgs.orphans().get(1);
            boolean shouldCreate = parsedArgs.asMap().containsKey("create") && (parsedArgs.asMap().get("create") == null || ((String)parsedArgs.asMap().get("create")).toLowerCase().equals("true"));
            try {
                Config config = SetPasswordCommand.loadNeo4jConfig(this.homeDir, this.configDir);
                File authDir = (File)config.get(DatabaseManagementSystemSettings.auth_store_directory);
                FileUserRepository userRepository = new FileUserRepository(new File(authDir, "auth.db").toPath(), (LogProvider)NullLogProvider.getInstance());
                userRepository.start();
                BasicPasswordPolicy passwordPolicy = new BasicPasswordPolicy();
                BasicAuthManager authManager = new BasicAuthManager((UserRepository)userRepository, (PasswordPolicy)passwordPolicy, Clock.systemUTC());
                try {
                    authManager.setUserPassword(username, password);
                    this.outsideWorld.stdOutLine("Changed password for user '" + username + "'");
                }
                catch (InvalidArgumentsException e) {
                    if (shouldCreate && e.getMessage().contains("does not exist")) {
                        authManager.getUserManager().newUser(username, password, false);
                        this.outsideWorld.stdOutLine("Created new user '" + username + "'");
                        break block7;
                    }
                    throw e;
                }
            }
            catch (Exception e) {
                throw new CommandFailed("Failed to set password for '" + username + "': " + e.getMessage(), e);
            }
            catch (Throwable t) {
                throw new CommandFailed("Failed to set password for '" + username + "': " + t.getMessage(), (Exception)new RuntimeException(t.getMessage()));
            }
        }
    }

    private static Config loadNeo4jConfig(Path homeDir, Path configDir) {
        ConfigLoader configLoader = new ConfigLoader(SetPasswordCommand.settings());
        return configLoader.loadConfig(Optional.of(homeDir.toFile()), Optional.of(configDir.resolve("neo4j.conf").toFile()), new Pair[0]);
    }

    private static List<Class<?>> settings() {
        ArrayList settings = new ArrayList();
        settings.add(GraphDatabaseSettings.class);
        settings.add(DatabaseManagementSystemSettings.class);
        return settings;
    }

    public static class Provider
    extends AdminCommand.Provider {
        public Provider() {
            super("set-password", new String[0]);
        }

        public Optional<String> arguments() {
            return Optional.of("[--create=<true|false>] <username> <password>");
        }

        public String description() {
            return "Sets the password for the specified user and removes the password change requirement. If the user does not exist an error message will be shown, unless you specify the option --create=true.";
        }

        public AdminCommand create(Path homeDir, Path configDir, OutsideWorld outsideWorld) {
            return new SetPasswordCommand(homeDir, configDir, outsideWorld);
        }
    }
}

