/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.admin.security;

import java.nio.file.Path;
import org.neo4j.cli.AbstractAdminCommand;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.ConfigUtils;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.security.Credential;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.server.security.auth.CommunitySecurityModule;
import org.neo4j.server.security.auth.FileUserRepository;
import org.neo4j.server.security.auth.LegacyCredential;
import org.neo4j.util.VisibleForTesting;
import picocli.CommandLine;

@CommandLine.Command(name="set-default-admin", description={"Sets the default admin user.%nThis user will be granted the admin role on startup if the system has no roles."})
public class SetDefaultAdminCommand
extends AbstractAdminCommand {
    public static final String ADMIN_INI = "admin.ini";
    @CommandLine.Parameters
    private String username;

    public SetDefaultAdminCommand(ExecutionContext ctx) {
        super(ctx);
    }

    public void execute() {
        Config config = this.loadNeo4jConfig();
        try {
            Path adminIniFile = CommunitySecurityModule.getInitialUserRepositoryFile(config).resolveSibling(ADMIN_INI);
            FileSystemAbstraction fs = this.ctx.fs();
            EmptyMemoryTracker memoryTracher = EmptyMemoryTracker.INSTANCE;
            if (fs.fileExists(adminIniFile)) {
                fs.deleteFile(adminIniFile);
            }
            FileUserRepository admins = new FileUserRepository(fs, adminIniFile, (InternalLogProvider)NullLogProvider.getInstance(), (MemoryTracker)memoryTracher);
            admins.init();
            admins.start();
            admins.create(new User(this.username, null, (Credential)LegacyCredential.INACCESSIBLE, false, false));
            admins.stop();
            admins.shutdown();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.ctx.out().println("default admin user set to '" + this.username + "'");
    }

    @VisibleForTesting
    Config loadNeo4jConfig() {
        Config cfg = Config.newBuilder().fromFileNoThrow(this.ctx.confDir().resolve("neo4j.conf")).set(GraphDatabaseSettings.neo4j_home, (Object)this.ctx.homeDir().toAbsolutePath()).commandExpansion(this.allowCommandExpansion).build();
        ConfigUtils.disableAllConnectors((Config)cfg);
        return cfg;
    }
}

