/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.systemgraph;

import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseContextProvider;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.security.AuthProviderFailedException;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.server.security.FormatException;
import org.neo4j.server.security.SecureHasher;
import org.neo4j.server.security.SystemGraphCredential;
import org.neo4j.server.security.systemgraph.versions.KnownCommunitySecurityComponentVersion;
import org.neo4j.util.VisibleForTesting;

public class SecurityGraphHelper {
    public static final String NATIVE_AUTH = "native";
    protected final AbstractSecurityLog securityLog;
    protected final Supplier<GraphDatabaseService> systemSupplier;
    protected final SecureHasher secureHasher;

    public SecurityGraphHelper(Supplier<GraphDatabaseService> systemSupplier, SecureHasher secureHasher, AbstractSecurityLog securityLog) {
        this.systemSupplier = systemSupplier;
        this.secureHasher = secureHasher;
        this.securityLog = securityLog;
    }

    public GraphDatabaseService getSystemDb() {
        return this.systemSupplier.get();
    }

    @VisibleForTesting
    public static Supplier<GraphDatabaseService> makeSystemSupplier(DatabaseContextProvider<?> databaseContextProvider) {
        return () -> ((DatabaseContext)databaseContextProvider.getDatabaseContext(NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID).orElseThrow(() -> new AuthProviderFailedException("No database called `system` was found."))).databaseFacade();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public User getUserByName(String username) {
        this.securityLog.debug(String.format("Looking up user '%s'", username));
        try (Transaction tx = this.systemSupplier.get().beginTx();){
            Node userNode = tx.findNode(KnownCommunitySecurityComponentVersion.USER_LABEL, "name", (Object)username);
            if (userNode == null) {
                this.securityLog.debug(String.format("User '%s' not found", username));
                User user2 = null;
                return user2;
            }
            User user = this.getUser(userNode);
            return user;
        }
        catch (NotFoundException n) {
            this.securityLog.debug(String.format("User '%s' not found", username));
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public User getUserById(String uuid) {
        this.securityLog.debug(String.format("Looking up user with id '%s'", uuid));
        if (uuid == null) {
            this.securityLog.debug("Cannot look up user with id = null");
            return null;
        }
        try (Transaction tx = this.systemSupplier.get().beginTx();){
            Node userNode = tx.findNode(KnownCommunitySecurityComponentVersion.USER_LABEL, "id", (Object)uuid);
            if (userNode == null) {
                this.securityLog.debug(String.format("User with id '%s' not found", uuid));
                User user2 = null;
                return user2;
            }
            User user = this.getUser(userNode);
            return user;
        }
        catch (NotFoundException n) {
            this.securityLog.debug(String.format("User with id '%s' not found", uuid));
            return null;
        }
    }

    protected User getUser(Node userNode) {
        String userId = (String)userNode.getProperty("id");
        String username = (String)userNode.getProperty("name");
        boolean requirePasswordChange = (Boolean)userNode.getProperty("passwordChangeRequired", (Object)false);
        SystemGraphCredential credential = null;
        Object maybeCredentials = userNode.getProperty("credentials", null);
        if (maybeCredentials instanceof String) {
            String rawCredentials = (String)maybeCredentials;
            try {
                credential = SystemGraphCredential.deserialize(rawCredentials, this.secureHasher);
            }
            catch (FormatException e) {
                this.securityLog.debug(String.format("Wrong format of credentials for user %s.", username));
                return null;
            }
        }
        User user = new User(username, userId, new User.SensitiveCredential(credential), requirePasswordChange, false, credential == null ? Collections.emptySet() : Set.of(new User.Auth(NATIVE_AUTH, userId)));
        this.securityLog.debug(String.format("Found user: %s", user));
        return user;
    }

    public User getUserByAuth(String provider, String authId) {
        return null;
    }

    public String getAuthId(String provider, String username) {
        return null;
    }

    public boolean hasExternalAuth(String username) {
        return false;
    }
}

