/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema.constraints;

import java.util.Objects;
import java.util.Set;
import org.neo4j.internal.schema.constraints.PropertyTypeSet;
import org.neo4j.internal.schema.constraints.SchemaValueType;
import org.neo4j.internal.schema.constraints.SpecialTypes;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.BooleanArray;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.DateArray;
import org.neo4j.values.storable.DateTimeArray;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationArray;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.FloatingPointArray;
import org.neo4j.values.storable.FloatingPointValue;
import org.neo4j.values.storable.IntegralArray;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.LocalDateTimeArray;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeArray;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.PointArray;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.ScalarValue;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TimeArray;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface TypeRepresentation {
    public static final Set<SchemaValueType> CONSTRAINABLE_LIST_TYPES = Set.of(SchemaValueType.LIST_BOOLEAN, SchemaValueType.LIST_STRING, SchemaValueType.LIST_INTEGER, SchemaValueType.LIST_FLOAT, SchemaValueType.LIST_DATE, SchemaValueType.LIST_ZONED_TIME, SchemaValueType.LIST_LOCAL_TIME, SchemaValueType.LIST_LOCAL_DATETIME, SchemaValueType.LIST_ZONED_DATETIME, SchemaValueType.LIST_DURATION, SchemaValueType.LIST_POINT);

    public String userDescription();

    public Ordering order();

    public static int compare(TypeRepresentation t1, TypeRepresentation t2) {
        return t1.order().compareTo(t2.order());
    }

    public static TypeRepresentation infer(Value value) {
        if (value == null || value == Values.NO_VALUE) {
            return SpecialTypes.NULL;
        }
        if (value instanceof ScalarValue) {
            if (value instanceof BooleanValue) {
                return SchemaValueType.BOOLEAN;
            }
            if (value instanceof TextValue) {
                return SchemaValueType.STRING;
            }
            if (value instanceof IntegralValue) {
                return SchemaValueType.INTEGER;
            }
            if (value instanceof FloatingPointValue) {
                return SchemaValueType.FLOAT;
            }
            if (value instanceof DateValue) {
                return SchemaValueType.DATE;
            }
            if (value instanceof DurationValue) {
                return SchemaValueType.DURATION;
            }
            if (value instanceof LocalDateTimeValue) {
                return SchemaValueType.LOCAL_DATETIME;
            }
            if (value instanceof DateTimeValue) {
                return SchemaValueType.ZONED_DATETIME;
            }
            if (value instanceof TimeValue) {
                return SchemaValueType.ZONED_TIME;
            }
            if (value instanceof LocalTimeValue) {
                return SchemaValueType.LOCAL_TIME;
            }
            if (value instanceof PointValue) {
                return SchemaValueType.POINT;
            }
        } else if (value instanceof ArrayValue) {
            ArrayValue array = (ArrayValue)value;
            if (array.isEmpty()) {
                return SpecialTypes.LIST_NOTHING;
            }
            if (value instanceof BooleanArray) {
                return SchemaValueType.LIST_BOOLEAN;
            }
            if (value instanceof TextArray) {
                return SchemaValueType.LIST_STRING;
            }
            if (value instanceof IntegralArray) {
                return SchemaValueType.LIST_INTEGER;
            }
            if (value instanceof FloatingPointArray) {
                return SchemaValueType.LIST_FLOAT;
            }
            if (value instanceof DateArray) {
                return SchemaValueType.LIST_DATE;
            }
            if (value instanceof DurationArray) {
                return SchemaValueType.LIST_DURATION;
            }
            if (value instanceof LocalDateTimeArray) {
                return SchemaValueType.LIST_LOCAL_DATETIME;
            }
            if (value instanceof DateTimeArray) {
                return SchemaValueType.LIST_ZONED_DATETIME;
            }
            if (value instanceof TimeArray) {
                return SchemaValueType.LIST_ZONED_TIME;
            }
            if (value instanceof LocalTimeArray) {
                return SchemaValueType.LIST_LOCAL_TIME;
            }
            if (value instanceof PointArray) {
                return SchemaValueType.LIST_POINT;
            }
            return SpecialTypes.LIST_ANY;
        }
        return SpecialTypes.ANY;
    }

    public static boolean disallows(PropertyTypeSet set, Value value) {
        Objects.requireNonNull(set);
        return !set.contains(TypeRepresentation.infer(value));
    }

    public static boolean isList(SchemaValueType type) {
        return CONSTRAINABLE_LIST_TYPES.contains(type);
    }

    public static boolean isNullable(TypeRepresentation type) {
        return true;
    }

    public static boolean hasListTypes(PropertyTypeSet set) {
        return set.contains(SpecialTypes.LIST_NOTHING);
    }

    public static void validate(PropertyTypeSet set) {
        int size = set.size();
        boolean hasListType = TypeRepresentation.hasListTypes(set);
        if (size == 0) {
            throw new IllegalArgumentException("Unable to create property type constraint because the provided union '" + set.userDescription() + "' is not legal: Must specify at least one property type.");
        }
    }

    public static enum Ordering {
        NULL_ORDER,
        BOOLEAN_ORDER,
        STRING_ORDER,
        INTEGER_ORDER,
        FLOAT_ORDER,
        DATE_ORDER,
        LOCAL_TIME_ORDER,
        ZONED_TIME_ORDER,
        LOCAL_DATETIME_ORDER,
        ZONED_DATETIME_ORDER,
        DURATION_ORDER,
        POINT_ORDER,
        LIST_NOTHING_ORDER,
        LIST_BOOLEAN_ORDER,
        LIST_STRING_ORDER,
        LIST_INTEGER_ORDER,
        LIST_FLOAT_ORDER,
        LIST_DATE_ORDER,
        LIST_LOCAL_TIME_ORDER,
        LIST_ZONED_TIME_ORDER,
        LIST_LOCAL_DATETIME_ORDER,
        LIST_ZONED_DATETIME_ORDER,
        LIST_DURATION_ORDER,
        LIST_POINT_ORDER,
        LIST_ANY_ORDER,
        ANY_ORDER;

    }
}

