/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.exceptions.schema;

import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.kernel.api.exceptions.Status;

public class SchemaRuleException
extends SchemaKernelException {
    private final SchemaDescriptorSupplier schemaThing;
    private final String messageTemplate;

    SchemaRuleException(Status status, String messageTemplate, SchemaDescriptorSupplier schemaThing, TokenNameLookup tokenNameLookup) {
        super(status, String.format(messageTemplate, SchemaRuleException.describe(schemaThing), schemaThing.schema().userDescription(tokenNameLookup)));
        this.schemaThing = schemaThing;
        this.messageTemplate = messageTemplate;
    }

    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        return String.format(this.messageTemplate, SchemaRuleException.describe(this.schemaThing), this.schemaThing.schema().userDescription(tokenNameLookup));
    }

    public static String describe(SchemaDescriptorSupplier schemaThing) {
        String tagType;
        SchemaDescriptor schema = schemaThing.schema();
        switch (schema.entityType()) {
            case NODE: {
                tagType = "label";
                break;
            }
            case RELATIONSHIP: {
                tagType = "relationship type";
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown entity type: " + schema.entityType()));
            }
        }
        if (schemaThing instanceof ConstraintDescriptor) {
            ConstraintDescriptor constraint = (ConstraintDescriptor)schemaThing;
            switch (constraint.type()) {
                case UNIQUE: {
                    return tagType + " uniqueness constraint";
                }
                case EXISTS: {
                    return tagType + " property existence constraint";
                }
                case UNIQUE_EXISTS: {
                    return schema.entityType().name().toLowerCase() + " key constraint";
                }
            }
            throw new AssertionError((Object)("Unknown constraint type: " + constraint.type()));
        }
        IndexDescriptor index = (IndexDescriptor)schemaThing;
        IndexType indexType = index.getIndexType();
        if (indexType != IndexType.BTREE) {
            String indexTypeName = indexType.name().toLowerCase();
            return indexTypeName + " " + tagType + " index";
        }
        return tagType + " index";
    }
}

