/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.factory.Maps;
import org.neo4j.graphdb.schema.IndexSetting;
import org.neo4j.graphdb.schema.IndexSettingImpl;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueCategory;
import org.neo4j.values.storable.Values;

public final class IndexConfig {
    private static final IndexConfig EMPTY = new IndexConfig((ImmutableMap<String, Value>)Maps.immutable.empty());
    private final ImmutableMap<String, Value> map;

    private IndexConfig(ImmutableMap<String, Value> map) {
        this.map = map;
    }

    public static IndexConfig empty() {
        return EMPTY;
    }

    public static IndexConfig with(String key, Value value) {
        return new IndexConfig((ImmutableMap<String, Value>)Maps.immutable.with((Object)key, (Object)value));
    }

    public static IndexConfig with(Map<String, Value> map) {
        for (Value value : map.values()) {
            IndexConfig.validate(value);
        }
        return new IndexConfig((ImmutableMap<String, Value>)Maps.immutable.withAll(map));
    }

    public static IndexConfig from(Map<IndexSetting, Object> map) {
        HashMap<String, Value> collectingMap = new HashMap<String, Value>();
        for (Map.Entry<IndexSetting, Object> entry : map.entrySet()) {
            IndexSetting setting = entry.getKey();
            Class type = setting.getType();
            Object value = entry.getValue();
            if (value == null || !type.isAssignableFrom(value.getClass())) {
                throw new IllegalArgumentException("Invalid value type for '" + setting.getSettingName() + "' setting. Expected a value of type " + type.getName() + ", but got value '" + value + "' of type " + (value == null ? "null" : value.getClass().getName()) + ".");
            }
            collectingMap.put(setting.getSettingName(), Values.of((Object)value));
        }
        return IndexConfig.with(collectingMap);
    }

    public static IndexSetting spatialMinSettingForCrs(CoordinateReferenceSystem crs) {
        switch (crs.getName()) {
            case "cartesian": {
                return IndexSettingImpl.SPATIAL_CARTESIAN_MIN;
            }
            case "cartesian-3d": {
                return IndexSettingImpl.SPATIAL_CARTESIAN_3D_MIN;
            }
            case "wgs-84": {
                return IndexSettingImpl.SPATIAL_WGS84_MIN;
            }
            case "wgs-84-3d": {
                return IndexSettingImpl.SPATIAL_WGS84_3D_MIN;
            }
        }
        throw new IllegalArgumentException("Unrecognized coordinate reference system " + crs);
    }

    public static IndexSetting spatialMaxSettingForCrs(CoordinateReferenceSystem crs) {
        switch (crs.getName()) {
            case "cartesian": {
                return IndexSettingImpl.SPATIAL_CARTESIAN_MAX;
            }
            case "cartesian-3d": {
                return IndexSettingImpl.SPATIAL_CARTESIAN_3D_MAX;
            }
            case "wgs-84": {
                return IndexSettingImpl.SPATIAL_WGS84_MAX;
            }
            case "wgs-84-3d": {
                return IndexSettingImpl.SPATIAL_WGS84_3D_MAX;
            }
        }
        throw new IllegalArgumentException("Unrecognized coordinate reference system " + crs);
    }

    private static void validate(Value value) {
        ValueCategory category = value.valueGroup().category();
        switch (category) {
            case GEOMETRY: 
            case GEOMETRY_ARRAY: 
            case TEMPORAL: 
            case TEMPORAL_ARRAY: 
            case UNKNOWN: 
            case NO_CATEGORY: {
                throw new IllegalArgumentException("Value type not support in index configuration: " + value + ".");
            }
        }
    }

    public IndexConfig withIfAbsent(String key, Value value) {
        IndexConfig.validate(value);
        if (this.map.containsKey((Object)key)) {
            return this;
        }
        return new IndexConfig((ImmutableMap<String, Value>)this.map.newWithKeyValue((Object)key, (Object)value));
    }

    public <T extends Value> T get(String key) {
        return (T)((Value)this.map.get((Object)key));
    }

    public <T extends Value> T get(IndexSetting indexSetting) {
        return this.get(indexSetting.getSettingName());
    }

    public <T extends Value> T getOrDefault(String key, T defaultValue) {
        T value = this.get(key);
        return value != null ? value : defaultValue;
    }

    public RichIterable<Pair<String, Value>> entries() {
        return this.map.keyValuesView();
    }

    public Map<String, Value> asMap() {
        return Collections.unmodifiableMap(this.map.toMap());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IndexConfig)) {
            return false;
        }
        IndexConfig that = (IndexConfig)o;
        return this.map.equals(that.map);
    }

    public int hashCode() {
        return Objects.hash(this.map);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("IndexConfig[");
        for (Pair entry : this.entries()) {
            sb.append((String)entry.getOne()).append(" -> ").append(entry.getTwo()).append(", ");
        }
        if (!this.map.isEmpty()) {
            sb.setLength(sb.length() - 2);
        }
        sb.append(']');
        return sb.toString();
    }
}

