/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema.constraints;

import org.neo4j.graphdb.schema.PropertyType;
import org.neo4j.internal.schema.constraints.TypeRepresentation;

public enum SchemaValueType implements TypeRepresentation
{
    BOOLEAN("BOOLEAN", TypeRepresentation.Ordering.BOOLEAN_ORDER),
    STRING("STRING", TypeRepresentation.Ordering.STRING_ORDER),
    INTEGER("INTEGER", TypeRepresentation.Ordering.INTEGER_ORDER),
    FLOAT("FLOAT", TypeRepresentation.Ordering.FLOAT_ORDER),
    DATE("DATE", TypeRepresentation.Ordering.DATE_ORDER),
    LOCAL_TIME("LOCAL TIME", TypeRepresentation.Ordering.LOCAL_TIME_ORDER),
    ZONED_TIME("ZONED TIME", TypeRepresentation.Ordering.ZONED_TIME_ORDER),
    LOCAL_DATETIME("LOCAL DATETIME", TypeRepresentation.Ordering.LOCAL_DATETIME_ORDER),
    ZONED_DATETIME("ZONED DATETIME", TypeRepresentation.Ordering.ZONED_DATETIME_ORDER),
    DURATION("DURATION", TypeRepresentation.Ordering.DURATION_ORDER),
    POINT("POINT", TypeRepresentation.Ordering.POINT_ORDER),
    LIST_BOOLEAN("LIST<BOOLEAN NOT NULL>", TypeRepresentation.Ordering.LIST_BOOLEAN_ORDER),
    LIST_STRING("LIST<STRING NOT NULL>", TypeRepresentation.Ordering.LIST_STRING_ORDER),
    LIST_INTEGER("LIST<INTEGER NOT NULL>", TypeRepresentation.Ordering.LIST_INTEGER_ORDER),
    LIST_FLOAT("LIST<FLOAT NOT NULL>", TypeRepresentation.Ordering.LIST_FLOAT_ORDER),
    LIST_DATE("LIST<DATE NOT NULL>", TypeRepresentation.Ordering.LIST_DATE_ORDER),
    LIST_LOCAL_TIME("LIST<LOCAL TIME NOT NULL>", TypeRepresentation.Ordering.LIST_LOCAL_TIME_ORDER),
    LIST_ZONED_TIME("LIST<ZONED TIME NOT NULL>", TypeRepresentation.Ordering.LIST_ZONED_TIME_ORDER),
    LIST_LOCAL_DATETIME("LIST<LOCAL DATETIME NOT NULL>", TypeRepresentation.Ordering.LIST_LOCAL_DATETIME_ORDER),
    LIST_ZONED_DATETIME("LIST<ZONED DATETIME NOT NULL>", TypeRepresentation.Ordering.LIST_ZONED_DATETIME_ORDER),
    LIST_DURATION("LIST<DURATION NOT NULL>", TypeRepresentation.Ordering.LIST_DURATION_ORDER),
    LIST_POINT("LIST<POINT NOT NULL>", TypeRepresentation.Ordering.LIST_POINT_ORDER);

    private final String userDescription;
    private final TypeRepresentation.Ordering order;

    private SchemaValueType(String userDescription, TypeRepresentation.Ordering order) {
        this.userDescription = userDescription;
        this.order = order;
    }

    @Override
    public String userDescription() {
        return this.userDescription;
    }

    @Override
    public TypeRepresentation.Ordering order() {
        return this.order;
    }

    public String serialize() {
        return this.name();
    }

    public String toString() {
        return this.userDescription;
    }

    public static SchemaValueType fromPublicApi(PropertyType propertyType) {
        return switch (propertyType) {
            default -> throw new MatchException(null, null);
            case PropertyType.BOOLEAN -> BOOLEAN;
            case PropertyType.STRING -> STRING;
            case PropertyType.INTEGER -> INTEGER;
            case PropertyType.FLOAT -> FLOAT;
            case PropertyType.DURATION -> DURATION;
            case PropertyType.DATE -> DATE;
            case PropertyType.ZONED_DATETIME -> ZONED_DATETIME;
            case PropertyType.LOCAL_DATETIME -> LOCAL_DATETIME;
            case PropertyType.ZONED_TIME -> ZONED_TIME;
            case PropertyType.LOCAL_TIME -> LOCAL_TIME;
            case PropertyType.POINT -> POINT;
            case PropertyType.LIST_BOOLEAN_NOT_NULL -> LIST_BOOLEAN;
            case PropertyType.LIST_STRING_NOT_NULL -> LIST_STRING;
            case PropertyType.LIST_INTEGER_NOT_NULL -> LIST_INTEGER;
            case PropertyType.LIST_FLOAT_NOT_NULL -> LIST_FLOAT;
            case PropertyType.LIST_DATE_NOT_NULL -> LIST_DATE;
            case PropertyType.LIST_LOCAL_TIME_NOT_NULL -> LIST_LOCAL_TIME;
            case PropertyType.LIST_ZONED_TIME_NOT_NULL -> LIST_ZONED_TIME;
            case PropertyType.LIST_LOCAL_DATETIME_NOT_NULL -> LIST_LOCAL_DATETIME;
            case PropertyType.LIST_ZONED_DATETIME_NOT_NULL -> LIST_ZONED_DATETIME;
            case PropertyType.LIST_DURATION_NOT_NULL -> LIST_DURATION;
            case PropertyType.LIST_POINT_NOT_NULL -> LIST_POINT;
        };
    }

    public PropertyType toPublicApi() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> PropertyType.BOOLEAN;
            case 1 -> PropertyType.STRING;
            case 2 -> PropertyType.INTEGER;
            case 3 -> PropertyType.FLOAT;
            case 9 -> PropertyType.DURATION;
            case 4 -> PropertyType.DATE;
            case 8 -> PropertyType.ZONED_DATETIME;
            case 7 -> PropertyType.LOCAL_DATETIME;
            case 6 -> PropertyType.ZONED_TIME;
            case 5 -> PropertyType.LOCAL_TIME;
            case 11 -> PropertyType.LIST_BOOLEAN_NOT_NULL;
            case 12 -> PropertyType.LIST_STRING_NOT_NULL;
            case 13 -> PropertyType.LIST_INTEGER_NOT_NULL;
            case 14 -> PropertyType.LIST_FLOAT_NOT_NULL;
            case 15 -> PropertyType.LIST_DATE_NOT_NULL;
            case 16 -> PropertyType.LIST_LOCAL_TIME_NOT_NULL;
            case 17 -> PropertyType.LIST_ZONED_TIME_NOT_NULL;
            case 18 -> PropertyType.LIST_LOCAL_DATETIME_NOT_NULL;
            case 19 -> PropertyType.LIST_ZONED_DATETIME_NOT_NULL;
            case 20 -> PropertyType.LIST_DURATION_NOT_NULL;
            case 21 -> PropertyType.LIST_POINT_NOT_NULL;
            case 10 -> PropertyType.POINT;
        };
    }
}

