/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.exceptions.schema;

import org.neo4j.common.TokenNameLookup;
import org.neo4j.exceptions.KernelException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.kernel.api.exceptions.Status;

public class CreateConstraintFailureException
extends SchemaKernelException {
    private final ConstraintDescriptor constraint;
    private final String cause;

    private CreateConstraintFailureException(ErrorGqlStatusObject gqlStatusObject, ConstraintDescriptor constraint, Throwable cause, String causeString) {
        super(gqlStatusObject, (Status)Status.Schema.ConstraintCreationFailed, cause, "Unable to create constraint %s: %s", constraint, causeString);
        this.constraint = constraint;
        this.cause = causeString;
    }

    public static CreateConstraintFailureException constraintCreationFailed(ConstraintDescriptor constraint, TokenNameLookup tokenNameLookup, Throwable cause) {
        String constraintString = constraint.userDescription(tokenNameLookup);
        return CreateConstraintFailureException.constraintCreationFailed(constraint, constraintString, cause, cause.getMessage());
    }

    public static CreateConstraintFailureException constraintCreationFailed(ConstraintDescriptor constraint, String cause) {
        return CreateConstraintFailureException.constraintCreationFailed(constraint, null, null, cause);
    }

    private static CreateConstraintFailureException constraintCreationFailed(ConstraintDescriptor constraint, String constraintString, Throwable cause, String causeString) {
        ErrorGqlStatusObject errorGqlStatusObject = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_50N11).withParam(GqlParams.StringParam.constrDescrOrName, constraint.getName() != null ? constraint.getName() : constraintString).build();
        return new CreateConstraintFailureException(errorGqlStatusObject, constraint, cause, causeString);
    }

    public ConstraintDescriptor constraint() {
        return this.constraint;
    }

    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        StringBuilder sb = new StringBuilder("Unable to create ").append(this.constraint.userDescription(tokenNameLookup));
        Throwable throwable = this.getCause();
        if (throwable instanceof KernelException) {
            KernelException kernelCause = (KernelException)throwable;
            sb.append(':').append(System.lineSeparator()).append(kernelCause.getUserMessage(tokenNameLookup));
        } else if (this.cause != null) {
            sb.append(':').append(System.lineSeparator()).append(this.cause);
        }
        return sb.append(". Note that only the first found violation is shown.").toString();
    }
}

