/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.impl;

import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.string.Globbing;

interface NamingRestrictions {
    public void verify(QualifiedName var1) throws IllegalNamingException;

    public static NamingRestrictions allOf(NamingRestrictions ... restrictions) {
        return name -> {
            for (NamingRestrictions restriction : restrictions) {
                restriction.verify(name);
            }
        };
    }

    public static NamingRestrictions rejectEmptyNamespace() {
        return name -> {
            if (name.namespace() == null || name.namespace().length == 0) {
                throw IllegalNamingException.invalidNameRootNamespace(name.name());
            }
        };
    }

    public static NamingRestrictions rejectReservedNamespace(List<String> namespaces) {
        Objects.requireNonNull(namespaces);
        Predicate filter = Globbing.compose(namespaces, List.of());
        return name -> {
            if (filter.test(name.toString())) {
                throw IllegalNamingException.invalidNameReservedNameSpace(namespaces, name.name());
            }
        };
    }

    public static NamingRestrictions rejectNone() {
        return name -> {};
    }

    public static class IllegalNamingException
    extends ProcedureException {
        private IllegalNamingException(ErrorGqlStatusObject gqlStatusObject, String message, Object ... parameters) {
            super(gqlStatusObject, (Status)Status.Procedure.ProcedureRegistrationFailed, message, parameters);
        }

        public static IllegalNamingException invalidNameReservedNameSpace(List<String> namespaces, String name) {
            ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N00).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N17).withParam(GqlParams.StringParam.procFun, name).build()).build();
            return new IllegalNamingException(gql, "It is not allowed to define procedures or functions in the reserved namespaces %s, consider using a proper package name instead e.g. \"org.example.com.%s\"", namespaces, name);
        }

        public static IllegalNamingException invalidNameRootNamespace(String name) {
            ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N00).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N17).withParam(GqlParams.StringParam.procFun, name).build()).build();
            return new IllegalNamingException(gql, "It is not allowed to define functions in the root namespace. Please define a namespace, e.g. `@UserFunction(\"org.example.com.%s\")", name);
        }
    }
}

