/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.neo4j.internal.kernel.api.procs.QualifiedName;

class ProcedureHolder<T> {
    private final Map<QualifiedName, Integer> nameToId = new HashMap<QualifiedName, Integer>();
    private final Map<QualifiedName, Integer> caseInsensitiveName2Id = new HashMap<QualifiedName, Integer>();
    private final List<T> store = new ArrayList<T>();

    ProcedureHolder() {
    }

    T get(QualifiedName name) {
        Integer id = this.name2Id(name);
        if (id == null) {
            return null;
        }
        return this.store.get(id);
    }

    T get(int id) {
        return this.store.get(id);
    }

    void put(QualifiedName name, T item, boolean caseInsensitive) {
        int id = this.store.size();
        this.store.add(item);
        this.nameToId.put(name, id);
        if (caseInsensitive) {
            this.caseInsensitiveName2Id.put(this.toLowerCaseName(name), id);
        } else {
            this.caseInsensitiveName2Id.remove(this.toLowerCaseName(name));
        }
    }

    int idOf(QualifiedName name) {
        Integer id = this.name2Id(name);
        if (id == null) {
            throw new NoSuchElementException();
        }
        return id;
    }

    List<T> all() {
        return this.store;
    }

    private Integer name2Id(QualifiedName name) {
        Integer id = this.nameToId.get(name);
        if (id == null) {
            QualifiedName lowerCaseName = this.toLowerCaseName(name);
            id = this.caseInsensitiveName2Id.get(lowerCaseName);
        }
        return id;
    }

    private QualifiedName toLowerCaseName(QualifiedName name) {
        String[] oldNs = name.namespace();
        String[] lowerCaseNamespace = new String[oldNs.length];
        for (int i = 0; i < oldNs.length; ++i) {
            lowerCaseNamespace[i] = oldNs[i].toLowerCase();
        }
        String lowercaseName = name.name().toLowerCase();
        return new QualifiedName(lowerCaseNamespace, lowercaseName);
    }
}

