/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin.routing;

import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.DatabaseReferenceRepository;
import org.neo4j.procedure.builtin.routing.BaseRoutingTableProcedureValidator;
import org.neo4j.procedure.builtin.routing.DatabaseAvailabilityChecker;

public class LocalRoutingTableProcedureValidator
extends BaseRoutingTableProcedureValidator {
    private final DatabaseAvailabilityChecker databaseAvailabilityChecker;

    public LocalRoutingTableProcedureValidator(DatabaseAvailabilityChecker databaseAvailabilityChecker, DatabaseReferenceRepository databaseReferenceRepo) {
        super(databaseReferenceRepo);
        this.databaseAvailabilityChecker = databaseAvailabilityChecker;
    }

    @Override
    public void isValidForServerSideRouting(DatabaseReference.Internal databaseReference) throws ProcedureException {
        this.assertDatabaseIsOperational(databaseReference);
    }

    @Override
    public void isValidForClientSideRouting(DatabaseReference.Internal databaseReference) throws ProcedureException {
        this.assertDatabaseIsOperational(databaseReference);
    }

    private void assertDatabaseIsOperational(DatabaseReference.Internal databaseReference) throws ProcedureException {
        if (!this.databaseAvailabilityChecker.isPresent(databaseReference)) {
            throw LocalRoutingTableProcedureValidator.databaseNotFoundException(databaseReference.alias().name());
        }
        if (!this.databaseAvailabilityChecker.isAvailable(databaseReference)) {
            throw LocalRoutingTableProcedureValidator.databaseNotAvailableException(databaseReference.alias().name());
        }
    }
}

