/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin;

import java.util.Objects;
import org.neo4j.configuration.helpers.DatabaseNameValidator;
import org.neo4j.configuration.helpers.NormalizedDatabaseName;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;

public class TransactionId {
    private static final String SEPARATOR = "-transaction-";
    private static final String EXPECTED_FORMAT_MSG = "(expected format: <databasename>-transaction-<id>)";
    private final NormalizedDatabaseName database;
    private final long internalId;

    public TransactionId(String database, long internalId) throws InvalidArgumentsException {
        this.database = new NormalizedDatabaseName(Objects.requireNonNull(database));
        if (internalId < 0L) {
            throw new InvalidArgumentsException("Negative ids are not supported (expected format: <databasename>-transaction-<id>)");
        }
        this.internalId = internalId;
    }

    static TransactionId parse(String queryIdText) throws InvalidArgumentsException {
        try {
            NormalizedDatabaseName database;
            int i = queryIdText.lastIndexOf(SEPARATOR);
            if (i != -1 && (database = TransactionId.normalizeAndValidateDatabaseName(queryIdText.substring(0, i))).name().length() > 0) {
                String qid = queryIdText.substring(i + SEPARATOR.length());
                long internalId = Long.parseLong(qid);
                return new TransactionId(database.name(), internalId);
            }
        }
        catch (NumberFormatException e) {
            throw new InvalidArgumentsException("Could not parse id (expected format: <databasename>-transaction-<id>)", (Throwable)e);
        }
        throw new InvalidArgumentsException("Could not parse id (expected format: <databasename>-transaction-<id>)");
    }

    NormalizedDatabaseName database() {
        return this.database;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionId other = (TransactionId)o;
        return this.internalId == other.internalId && this.database.equals((Object)other.database);
    }

    public int hashCode() {
        return Objects.hash(this.database, this.internalId);
    }

    public String toString() {
        return this.database.name() + SEPARATOR + this.internalId;
    }

    private static NormalizedDatabaseName normalizeAndValidateDatabaseName(String databaseName) {
        NormalizedDatabaseName normalizedDatabaseName = new NormalizedDatabaseName(databaseName);
        DatabaseNameValidator.validateInternalDatabaseName((NormalizedDatabaseName)normalizedDatabaseName);
        return normalizedDatabaseName;
    }
}

