/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;
import org.neo4j.kernel.api.QueryLanguage;
import org.neo4j.kernel.api.exceptions.ComponentInjectionException;
import org.neo4j.kernel.api.procedure.CallableProcedure;
import org.neo4j.kernel.api.procedure.CallableUserAggregationFunction;
import org.neo4j.kernel.api.procedure.CallableUserFunction;
import org.neo4j.kernel.api.procedure.FailedLoadAggregatedFunction;
import org.neo4j.kernel.api.procedure.FailedLoadFunction;
import org.neo4j.kernel.api.procedure.FailedLoadProcedure;
import org.neo4j.kernel.api.procedure.QueryLanguageScope;
import org.neo4j.kernel.api.procedure.SystemProcedure;
import org.neo4j.logging.InternalLog;
import org.neo4j.procedure.Admin;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Internal;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.NotThreadSafe;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.ThreadSafe;
import org.neo4j.procedure.UnsupportedDatabaseTypes;
import org.neo4j.procedure.UserAggregationFunction;
import org.neo4j.procedure.UserAggregationResult;
import org.neo4j.procedure.UserAggregationUpdate;
import org.neo4j.procedure.UserFunction;
import org.neo4j.procedure.impl.ComponentRegistry;
import org.neo4j.procedure.impl.Cypher5TypeCheckers;
import org.neo4j.procedure.impl.FieldInjections;
import org.neo4j.procedure.impl.FieldSetter;
import org.neo4j.procedure.impl.MethodSignatureCompiler;
import org.neo4j.procedure.impl.NamingRestrictions;
import org.neo4j.procedure.impl.ProcedureCompilation;
import org.neo4j.procedure.impl.ProcedureConfig;
import org.neo4j.procedure.impl.ProcedureOutputSignatureCompiler;
import org.neo4j.string.Globbing;

class ProcedureCompiler {
    private final ProcedureOutputSignatureCompiler outputSignatureCompiler;
    private final MethodSignatureCompiler inputSignatureDeterminer;
    private final FieldInjections safeFieldInjections;
    private final FieldInjections allFieldInjections;
    private final InternalLog log;
    private final Cypher5TypeCheckers typeCheckers;
    private final ProcedureConfig config;
    private final NamingRestrictions functionRestrictions;
    private final NamingRestrictions procedureRestrictions;

    ProcedureCompiler(Cypher5TypeCheckers typeCheckers, ComponentRegistry safeComponents, ComponentRegistry allComponents, InternalLog log, ProcedureConfig config) {
        this(new MethodSignatureCompiler(typeCheckers), new ProcedureOutputSignatureCompiler(typeCheckers), new FieldInjections(safeComponents), new FieldInjections(allComponents), log, typeCheckers, config, NamingRestrictions.rejectEmptyNamespace(), NamingRestrictions.rejectNone());
    }

    private ProcedureCompiler(MethodSignatureCompiler inputSignatureCompiler, ProcedureOutputSignatureCompiler outputSignatureCompiler, FieldInjections safeFieldInjections, FieldInjections allFieldInjections, InternalLog log, Cypher5TypeCheckers typeCheckers, ProcedureConfig config, NamingRestrictions functionRestrictions, NamingRestrictions procedureRestrictions) {
        this.inputSignatureDeterminer = inputSignatureCompiler;
        this.outputSignatureCompiler = outputSignatureCompiler;
        this.safeFieldInjections = safeFieldInjections;
        this.allFieldInjections = allFieldInjections;
        this.log = log;
        this.typeCheckers = typeCheckers;
        this.config = config;
        this.functionRestrictions = functionRestrictions;
        this.procedureRestrictions = procedureRestrictions;
    }

    List<CallableUserFunction> compileFunction(Class<?> fcnDefinition, boolean isBuiltin, ClassLoader parentClassLoader, Predicate<String> methodNameFilter) throws ProcedureException {
        try {
            List<Method> functionMethods = Arrays.stream(fcnDefinition.getDeclaredMethods()).filter(m -> m.isAnnotationPresent(UserFunction.class)).toList();
            if (functionMethods.isEmpty()) {
                return Collections.emptyList();
            }
            this.assertValidConstructor(fcnDefinition);
            ArrayList<CallableUserFunction> out = new ArrayList<CallableUserFunction>(functionMethods.size());
            for (Method method : functionMethods) {
                String definedName;
                String valueName;
                QualifiedName funcName = this.extractName(fcnDefinition, method, valueName = method.getAnnotation(UserFunction.class).value(), definedName = method.getAnnotation(UserFunction.class).name());
                if (!methodNameFilter.test(funcName.toString())) continue;
                if (isBuiltin || this.config.isWhitelisted(funcName.toString())) {
                    out.add(this.compileFunction(fcnDefinition, method, funcName, parentClassLoader));
                    continue;
                }
                this.log.warn(String.format("The function '%s' is not on the allowlist and won't be loaded.", funcName));
            }
            out.sort(Comparator.comparing(a -> a.signature().name().toString()));
            return out;
        }
        catch (ProcedureException e) {
            throw e;
        }
        catch (Exception e) {
            throw ProcedureException.compilationFailed((boolean)false, (String)fcnDefinition.getName(), (Throwable)e);
        }
    }

    List<CallableUserAggregationFunction> compileAggregationFunction(Class<?> fcnDefinition, ClassLoader parentClassLoader, Predicate<String> methodNameFilter) throws ProcedureException {
        try {
            List<Method> methods = Arrays.stream(fcnDefinition.getDeclaredMethods()).filter(m -> m.isAnnotationPresent(UserAggregationFunction.class)).toList();
            if (methods.isEmpty()) {
                return Collections.emptyList();
            }
            this.assertValidConstructor(fcnDefinition);
            ArrayList<CallableUserAggregationFunction> out = new ArrayList<CallableUserAggregationFunction>(methods.size());
            for (Method method : methods) {
                String definedName;
                String valueName;
                QualifiedName funcName = this.extractName(fcnDefinition, method, valueName = method.getAnnotation(UserAggregationFunction.class).value(), definedName = method.getAnnotation(UserAggregationFunction.class).name());
                if (!methodNameFilter.test(funcName.toString())) continue;
                if (this.config.isWhitelisted(funcName.toString())) {
                    out.add(this.compileAggregationFunction(fcnDefinition, method, funcName, parentClassLoader));
                    continue;
                }
                this.log.warn(String.format("The function '%s' is not on the allowlist and won't be loaded.", funcName));
            }
            out.sort(Comparator.comparing(a -> a.signature().name().toString()));
            return out;
        }
        catch (ProcedureException e) {
            throw e;
        }
        catch (Exception e) {
            throw ProcedureException.compilationFailed((boolean)false, (String)fcnDefinition.getSimpleName(), (Throwable)e);
        }
    }

    List<CallableProcedure> compileProcedure(Class<?> procDefinition, boolean fullAccess, ClassLoader parentClassLoader, Predicate<String> methodNameFilter) throws ProcedureException {
        try {
            List<Method> procedureMethods = Arrays.stream(procDefinition.getDeclaredMethods()).filter(m -> m.isAnnotationPresent(Procedure.class)).toList();
            if (procedureMethods.isEmpty()) {
                return Collections.emptyList();
            }
            this.assertValidConstructor(procDefinition);
            ArrayList<CallableProcedure> out = new ArrayList<CallableProcedure>(procedureMethods.size());
            for (Method method : procedureMethods) {
                String definedName;
                String valueName;
                QualifiedName procName = this.extractName(procDefinition, method, valueName = method.getAnnotation(Procedure.class).value(), definedName = method.getAnnotation(Procedure.class).name());
                if (!methodNameFilter.test(procName.toString())) continue;
                if (fullAccess || this.config.isWhitelisted(procName.toString())) {
                    out.add(this.compileProcedure(procDefinition, method, fullAccess, procName, parentClassLoader));
                    continue;
                }
                this.log.warn(String.format("The procedure '%s' is not on the allowlist and won't be loaded.", procName));
            }
            out.sort(Comparator.comparing(a -> a.signature().name().toString()));
            return out;
        }
        catch (ProcedureException e) {
            throw e;
        }
        catch (Exception e) {
            throw ProcedureException.compilationFailed((boolean)true, (String)procDefinition.getSimpleName(), (Throwable)e);
        }
    }

    private CallableProcedure compileProcedure(Class<?> procDefinition, Method method, boolean fullAccess, QualifiedName procName, ClassLoader parentClassLoader) throws ProcedureException {
        this.procedureRestrictions.verify(procName);
        List<FieldSignature> inputSignature = this.inputSignatureDeterminer.signatureFor(method);
        List<FieldSignature> outputSignature = this.outputSignatureCompiler.fieldSignatures(method);
        String description = this.description(method);
        Procedure procedure = method.getAnnotation(Procedure.class);
        Mode mode = procedure.mode();
        boolean admin = method.isAnnotationPresent(Admin.class);
        boolean systemProcedure = method.isAnnotationPresent(SystemProcedure.class);
        boolean allowExpiredCredentials = systemProcedure && method.getAnnotation(SystemProcedure.class).allowExpiredCredentials();
        boolean internal = method.isAnnotationPresent(Internal.class);
        UnsupportedDatabaseTypes.DatabaseType[] unsupportedDbTypes = method.isAnnotationPresent(UnsupportedDatabaseTypes.class) ? method.getAnnotation(UnsupportedDatabaseTypes.class).value() : new UnsupportedDatabaseTypes.DatabaseType[]{};
        boolean threadSafe = !method.isAnnotationPresent(NotThreadSafe.class);
        boolean isDeprecated = method.isAnnotationPresent(Deprecated.class);
        String deprecated = this.deprecated(() -> ((Procedure)procedure).deprecatedBy(), "Use of @Procedure(deprecatedBy) without @Deprecated in " + String.valueOf(procName), isDeprecated);
        String warning = procedure.warning().isEmpty() ? null : procedure.warning();
        List<FieldSetter> setters = this.allFieldInjections.setters(procDefinition);
        if (!fullAccess && !this.config.fullAccessFor(procName.toString())) {
            try {
                setters = this.safeFieldInjections.setters(procDefinition);
            }
            catch (ComponentInjectionException e) {
                description = this.describeAndLogLoadFailure(procName);
                ProcedureSignature signature = new ProcedureSignature(procName, inputSignature, outputSignature, Mode.DEFAULT, admin, isDeprecated, deprecated, description, warning, procedure.eager(), false, systemProcedure, internal, allowExpiredCredentials, threadSafe, ProcedureCompiler.getSupportedCypherVersions(method), unsupportedDbTypes);
                return new FailedLoadProcedure(signature);
            }
        }
        ProcedureSignature signature = new ProcedureSignature(procName, inputSignature, outputSignature, mode, admin, isDeprecated, deprecated, description, warning, procedure.eager(), false, systemProcedure, internal, allowExpiredCredentials, threadSafe, ProcedureCompiler.getSupportedCypherVersions(method), unsupportedDbTypes);
        return ProcedureCompilation.compileProcedure(signature, setters, method, parentClassLoader);
    }

    private static Set<QueryLanguage> getSupportedCypherVersions(Method method) throws IllegalArgumentException {
        QueryLanguageScope annotation = method.getAnnotation(QueryLanguageScope.class);
        if (annotation == null) {
            return QueryLanguage.ALL;
        }
        QueryLanguage[] scope = annotation.scope();
        if (scope == null || scope.length == 0) {
            return QueryLanguage.ALL;
        }
        return EnumSet.copyOf(Arrays.asList(scope));
    }

    List<CallableProcedure> compileProcedure(Class<?> procDefinition, boolean fullAccess) throws ProcedureException {
        return this.compileProcedure(procDefinition, fullAccess, CallableUserFunction.class.getClassLoader(), Globbing.MATCH_ALL);
    }

    List<CallableUserAggregationFunction> compileAggregationFunction(Class<?> fcnDefinition) throws ProcedureException {
        return this.compileAggregationFunction(fcnDefinition, CallableUserFunction.class.getClassLoader(), Globbing.MATCH_ALL);
    }

    List<CallableUserFunction> compileFunction(Class<?> fcnDefinition, boolean isBuiltin) throws ProcedureException {
        return this.compileFunction(fcnDefinition, isBuiltin, CallableUserFunction.class.getClassLoader(), Globbing.MATCH_ALL);
    }

    private String describeAndLogLoadFailure(QualifiedName name) {
        String nameStr = name.toString();
        String description = nameStr + " is unavailable because it is sandboxed and has dependencies outside of the sandbox. Sandboxing is controlled by the " + GraphDatabaseSettings.procedure_unrestricted.name() + " setting. Only unrestrict procedures you can trust with access to database internals.";
        this.log.warn(description);
        return description;
    }

    private CallableUserFunction compileFunction(Class<?> procDefinition, Method method, QualifiedName procName, ClassLoader parentClassLoader) throws ProcedureException {
        this.functionRestrictions.verify(procName);
        List<FieldSignature> inputSignature = this.inputSignatureDeterminer.signatureFor(method);
        Class<?> returnType = method.getReturnType();
        Cypher5TypeCheckers.TypeChecker typeChecker = this.typeCheckers.checkerFor(returnType);
        String description = this.description(method);
        UserFunction function = method.getAnnotation(UserFunction.class);
        boolean internal = method.isAnnotationPresent(Internal.class);
        boolean threadSafe = !method.isAnnotationPresent(NotThreadSafe.class);
        boolean isDeprecated = method.isAnnotationPresent(Deprecated.class);
        String deprecated = this.deprecated(() -> ((UserFunction)function).deprecatedBy(), "Use of @UserFunction(deprecatedBy) without @Deprecated in " + String.valueOf(procName), isDeprecated);
        List<FieldSetter> setters = this.allFieldInjections.setters(procDefinition);
        if (!this.config.fullAccessFor(procName.toString())) {
            try {
                setters = this.safeFieldInjections.setters(procDefinition);
            }
            catch (ComponentInjectionException e) {
                description = this.describeAndLogLoadFailure(procName);
                UserFunctionSignature signature = new UserFunctionSignature(procName, inputSignature, typeChecker.type(), isDeprecated, deprecated, description, null, false, false, internal, threadSafe, ProcedureCompiler.getSupportedCypherVersions(method));
                return new FailedLoadFunction(signature);
            }
        }
        UserFunctionSignature signature = new UserFunctionSignature(procName, inputSignature, typeChecker.type(), isDeprecated, deprecated, description, null, false, false, internal, threadSafe, ProcedureCompiler.getSupportedCypherVersions(method));
        return ProcedureCompilation.compileFunction(signature, setters, method, parentClassLoader);
    }

    private CallableUserAggregationFunction compileAggregationFunction(Class<?> definition, Method create, QualifiedName funcName, ClassLoader parentClassLoader) throws ProcedureException {
        this.functionRestrictions.verify(funcName);
        Method update = null;
        Method result = null;
        Class<?> aggregator = create.getReturnType();
        for (Method m : aggregator.getDeclaredMethods()) {
            if (m.isAnnotationPresent(UserAggregationUpdate.class)) {
                if (update != null) {
                    throw ProcedureException.duplicatedAnnotatedMethods((String)aggregator.getSimpleName(), (String)UserAggregationUpdate.class.getSimpleName());
                }
                update = m;
            }
            if (!m.isAnnotationPresent(UserAggregationResult.class)) continue;
            if (result != null) {
                throw ProcedureException.duplicatedAnnotatedMethods((String)aggregator.getSimpleName(), (String)UserAggregationResult.class.getSimpleName());
            }
            result = m;
        }
        if (result == null || update == null) {
            throw ProcedureException.missingAnnotatedMethods((String)aggregator.getSimpleName());
        }
        if (update.getReturnType() != Void.TYPE) {
            throw ProcedureException.methodMustBeVoid((String)aggregator.getSimpleName(), (String)update.getName(), (String)update.getReturnType().getSimpleName());
        }
        if (!Modifier.isPublic(create.getModifiers())) {
            throw ProcedureException.aggregationMethodNotPublic((String)definition.getSimpleName(), (String)create.getName());
        }
        if (!Modifier.isPublic(aggregator.getModifiers())) {
            throw ProcedureException.aggregationClassNotPublic((String)aggregator.getSimpleName());
        }
        if (!Modifier.isPublic(update.getModifiers())) {
            throw ProcedureException.aggregationUpdateMethodNotPublic((String)aggregator.getSimpleName(), (String)update.getName());
        }
        if (!Modifier.isPublic(result.getModifiers())) {
            throw ProcedureException.aggregationResultMethodNotPublic((String)aggregator.getSimpleName(), (String)result.getName());
        }
        List<FieldSignature> inputSignature = this.inputSignatureDeterminer.signatureFor(update);
        Class<?> returnType = result.getReturnType();
        Cypher5TypeCheckers.TypeChecker valueConverter = this.typeCheckers.checkerFor(returnType);
        String description = this.description(create);
        UserAggregationFunction function = create.getAnnotation(UserAggregationFunction.class);
        boolean isDeprecated = create.isAnnotationPresent(Deprecated.class);
        String deprecated = this.deprecated(() -> ((UserAggregationFunction)function).deprecatedBy(), "Use of @UserAggregationFunction(deprecatedBy) without @Deprecated in " + String.valueOf(funcName), isDeprecated);
        boolean internal = create.isAnnotationPresent(Internal.class);
        boolean threadSafe = create.isAnnotationPresent(ThreadSafe.class);
        List<FieldSetter> setters = this.allFieldInjections.setters(definition);
        if (!this.config.fullAccessFor(funcName.toString())) {
            try {
                setters = this.safeFieldInjections.setters(definition);
            }
            catch (ComponentInjectionException e) {
                description = this.describeAndLogLoadFailure(funcName);
                UserFunctionSignature signature = new UserFunctionSignature(funcName, inputSignature, valueConverter.type(), isDeprecated, deprecated, description, null, false, false, internal, threadSafe, ProcedureCompiler.getSupportedCypherVersions(create));
                return new FailedLoadAggregatedFunction(signature);
            }
        }
        UserFunctionSignature signature = new UserFunctionSignature(funcName, inputSignature, valueConverter.type(), isDeprecated, deprecated, description, null, false, false, internal, threadSafe, ProcedureCompiler.getSupportedCypherVersions(create));
        return ProcedureCompilation.compileAggregation(signature, setters, create, update, result, parentClassLoader);
    }

    private String deprecated(Supplier<String> supplier, String warning, Boolean isDeprecated) {
        String deprecatedBy = supplier.get();
        String deprecated = null;
        if (isDeprecated.booleanValue()) {
            deprecated = deprecatedBy.isEmpty() ? null : deprecatedBy;
        } else if (!deprecatedBy.isEmpty()) {
            this.log.warn(warning);
            deprecated = deprecatedBy;
        }
        return deprecated;
    }

    private String description(Method method) {
        if (method.isAnnotationPresent(Description.class)) {
            return method.getAnnotation(Description.class).value();
        }
        return null;
    }

    private void assertValidConstructor(Class<?> procDefinition) throws ProcedureException {
        boolean hasValidConstructor = false;
        for (Constructor<?> constructor : procDefinition.getConstructors()) {
            if (!Modifier.isPublic(constructor.getModifiers()) || constructor.getParameterCount() != 0) continue;
            hasValidConstructor = true;
            break;
        }
        if (!hasValidConstructor) {
            throw ProcedureException.unableToFindPublicConstructor((String)procDefinition.getSimpleName());
        }
    }

    private QualifiedName extractName(Class<?> procDefinition, Method m, String valueName, String definedName) {
        String procName;
        String string = procName = definedName.isBlank() ? valueName : definedName;
        if (!procName.isBlank()) {
            String[] split = procName.split("\\.");
            if (split.length == 1) {
                return new QualifiedName(split[0]);
            }
            int lastElement = split.length - 1;
            return new QualifiedName(Arrays.copyOf(split, lastElement), split[lastElement]);
        }
        Package pkg = procDefinition.getPackage();
        String[] namespace = pkg == null ? ArrayUtils.EMPTY_STRING_ARRAY : pkg.getName().split("\\.");
        String name = m.getName();
        return new QualifiedName(namespace, name);
    }

    ProcedureCompiler withAdditionalProcedureRestrictions(NamingRestrictions additionalProcedureRestrictions) {
        return new ProcedureCompiler(this.inputSignatureDeterminer, this.outputSignatureCompiler, this.safeFieldInjections, this.allFieldInjections, this.log, this.typeCheckers, this.config, this.functionRestrictions, NamingRestrictions.allOf(this.procedureRestrictions, additionalProcedureRestrictions));
    }
}

