/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin;

import java.security.NoSuchAlgorithmException;
import java.time.Clock;
import java.time.Duration;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.capabilities.CapabilitiesService;
import org.neo4j.capabilities.Capability;
import org.neo4j.common.DependencyResolver;
import org.neo4j.common.Edition;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.SettingImpl;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseContextProvider;
import org.neo4j.dbms.database.SystemGraphComponent;
import org.neo4j.dbms.database.SystemGraphComponents;
import org.neo4j.fabric.executor.FabricExecutor;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.QueryLanguage;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.net.NetworkConnectionTracker;
import org.neo4j.kernel.api.net.TrackedNetworkConnection;
import org.neo4j.kernel.api.procedure.QueryLanguageScope;
import org.neo4j.kernel.api.procedure.SystemProcedure;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogTimeZone;
import org.neo4j.procedure.Admin;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Internal;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.builtin.CapabilityResult;
import org.neo4j.procedure.builtin.ConfigResult;
import org.neo4j.procedure.builtin.ConnectionTerminationFailedResult;
import org.neo4j.procedure.builtin.ConnectionTerminationResult;
import org.neo4j.procedure.builtin.ListConnectionResult;
import org.neo4j.procedure.builtin.ProceduresTimeFormatHelper;
import org.neo4j.router.QueryRouter;
import org.neo4j.router.transaction.TransactionLookup;
import org.neo4j.storageengine.api.StoreIdProvider;
import org.neo4j.storageengine.util.StoreIdDecodeUtils;

public class BuiltInDbmsProcedures {
    public static final String UPGRADE_PENDING_RESULT = "Upgrade pending";
    private static final int HARD_CHAR_LIMIT = 2048;
    @Context
    public Log log;
    @Context
    public DependencyResolver resolver;
    @Context
    public GraphDatabaseAPI graph;
    @Context
    public Transaction transaction;
    @Context
    public KernelTransaction kernelTransaction;
    @Context
    public SecurityContext securityContext;
    @Context
    public ProcedureCallContext callContext;
    @Context
    public SystemGraphComponents systemGraphComponents;

    @SystemProcedure
    @Description(value="Provides information regarding the DBMS.")
    @Procedure(name="dbms.info", mode=Mode.DBMS)
    public Stream<SystemInfo> databaseInfo() throws NoSuchAlgorithmException {
        GraphDatabaseAPI systemGraph = this.getSystemDatabase();
        return BuiltInDbmsProcedures.dbmsInfo(systemGraph);
    }

    public static Stream<SystemInfo> dbmsInfo(GraphDatabaseAPI system) {
        Config config = (Config)system.getDependencyResolver().resolveDependency(Config.class);
        StoreIdProvider storeIdProvider = BuiltInDbmsProcedures.getSystemDatabaseStoreIdProvider(system);
        String creationTime = ProceduresTimeFormatHelper.formatTime(storeIdProvider.getStoreId().getCreationTime(), ((LogTimeZone)config.get(GraphDatabaseSettings.db_timezone)).getZoneId());
        return Stream.of(new SystemInfo(StoreIdDecodeUtils.decodeId((StoreIdProvider)storeIdProvider), system.databaseName(), creationTime));
    }

    @Admin
    @SystemProcedure
    @Description(value="List the currently active configuration settings of Neo4j.")
    @Procedure(name="dbms.listConfig", mode=Mode.DBMS)
    public Stream<ConfigResult> listConfig(@Name(value="searchString", defaultValue="", description="A string that filters on the name of config settings.") String searchString) {
        String lowerCasedSearchString = searchString.toLowerCase();
        ArrayList results = new ArrayList();
        Config config = (Config)this.graph.getDependencyResolver().resolveDependency(Config.class);
        config.getDeclaredSettings().values().forEach(setting -> {
            if (!((SettingImpl)setting).internal() && setting.name().toLowerCase().contains(lowerCasedSearchString)) {
                results.add(new ConfigResult((Setting<Object>)setting, config));
            }
        });
        return results.stream().sorted(Comparator.comparing(c -> c.name));
    }

    @Internal
    @SystemProcedure
    @Description(value="Return config settings interesting to clients (e.g. Neo4j Browser)")
    @Procedure(name="dbms.clientConfig", mode=Mode.DBMS)
    public Stream<ConfigResult> listClientConfig() {
        ArrayList results = new ArrayList();
        Set browserSettings = Stream.of("browser.allow_outgoing_connections", "browser.credential_timeout", "browser.retain_connection_credentials", "browser.retain_editor_history", "dbms.security.auth_enabled", "browser.remote_content_hostname_whitelist", "browser.post_connect_cmd", "client.allow_telemetry", "server.metrics.prefix").collect(Collectors.toCollection(HashSet::new));
        Config config = (Config)this.graph.getDependencyResolver().resolveDependency(Config.class);
        config.getDeclaredSettings().values().forEach(setting -> {
            if (browserSettings.contains(setting.name().toLowerCase())) {
                results.add(new ConfigResult((Setting<Object>)setting, config));
            }
        });
        return results.stream().sorted(Comparator.comparing(c -> c.name));
    }

    @Description(value="Attaches a map of data to the transaction. The data will be printed when listing queries, and inserted into the query log.")
    @Procedure(name="tx.setMetaData", mode=Mode.DBMS)
    public void setTXMetaData(@Name(value="data", description="Metadata to attach to the transaction.") Map<String, Object> data) {
        int totalCharSize = data.entrySet().stream().mapToInt(e -> ((String)e.getKey()).length() + (e.getValue() != null ? e.getValue().toString().length() : 0)).sum();
        if (totalCharSize >= 2048) {
            throw new IllegalArgumentException(String.format("Invalid transaction meta-data, expected the total number of chars for keys and values to be less than %d, got %d", 2048, totalCharSize));
        }
        InternalTransaction internalTransaction = (InternalTransaction)this.transaction;
        Config config = (Config)this.graph.getDependencyResolver().resolveDependency(Config.class);
        ((TransactionLookup)this.graph.getDependencyResolver().resolveDependency(TransactionLookup.class)).findTransactionContaining(internalTransaction).ifPresentOrElse(parent -> parent.setMetaData(data), () -> internalTransaction.setMetaData(data));
    }

    @SystemProcedure
    @Description(value="Provides attached transaction metadata.")
    @Procedure(name="tx.getMetaData", mode=Mode.DBMS)
    public Stream<MetadataResult> getTXMetaData() {
        return Stream.of(((InternalTransaction)this.transaction).kernelTransaction().getMetaData()).map(MetadataResult::new);
    }

    @Admin
    @SystemProcedure
    @Description(value="Clears all query caches.")
    @Procedure(name="db.clearQueryCaches", mode=Mode.DBMS)
    public Stream<StringResult> clearAllQueryCaches() {
        long numberOfClearedQueries;
        QueryExecutionEngine queryExecutionEngine = (QueryExecutionEngine)this.graph.getDependencyResolver().resolveDependency(QueryExecutionEngine.class);
        long clearedRouterAndCompositeQueries = 0L;
        if (this.graph.getDependencyResolver().containsDependency(FabricExecutor.class)) {
            FabricExecutor fabricExecutor = (FabricExecutor)this.graph.getDependencyResolver().resolveDependency(FabricExecutor.class);
            clearedRouterAndCompositeQueries = fabricExecutor.clearQueryCachesForDatabase(this.graph.databaseName());
        }
        if (this.graph.getDependencyResolver().containsDependency(QueryRouter.class)) {
            QueryRouter queryRouter = (QueryRouter)this.graph.getDependencyResolver().resolveDependency(QueryRouter.class);
            clearedRouterAndCompositeQueries += queryRouter.clearQueryCachesForDatabase(this.graph.databaseName());
        }
        if (this.kernelTransaction.isSPDTransaction()) {
            this.kernelTransaction.clearSPDQueryCaches();
        }
        Object result = (numberOfClearedQueries = Math.max(queryExecutionEngine.clearQueryCaches(), clearedRouterAndCompositeQueries) - 1L) == 0L ? "Query cache already empty." : "Query caches successfully cleared of " + numberOfClearedQueries + " queries.";
        this.log.info("Called db.clearQueryCaches(): " + (String)result);
        return Stream.of(new StringResult((String)result));
    }

    @Deprecated(since="5.9.0")
    @Admin
    @SystemProcedure
    @Description(value="Report the current status of the system database sub-graph schema.")
    @Procedure(name="dbms.upgradeStatus", mode=Mode.READ, deprecatedBy="Automatic upgrade")
    @QueryLanguageScope(scope={QueryLanguage.CYPHER_5})
    public Stream<SystemGraphComponentStatusResult> upgradeStatus() throws ProcedureException {
        if (!this.callContext.isSystemDatabase()) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, "This is an administration command and it should be executed against the system database: dbms.upgradeStatus", new Object[0]);
        }
        return Stream.of(BuiltInDbmsProcedures.getAggregateUpgradeStatus(this.systemGraphComponents, this.resolver, this.transaction));
    }

    @Deprecated(since="5.9.0")
    @Admin
    @SystemProcedure
    @Description(value="Upgrade the system database schema if it is not the current schema.")
    @Procedure(name="dbms.upgrade", mode=Mode.WRITE, deprecatedBy="Automatic upgrade")
    @QueryLanguageScope(scope={QueryLanguage.CYPHER_5})
    public Stream<SystemGraphComponentUpgradeResult> upgrade() throws ProcedureException {
        if (!this.callContext.isSystemDatabase()) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, "This is an administration command and it should be executed against the system database: dbms.upgrade", new Object[0]);
        }
        SystemGraphComponents.UpgradeCheckResult upgradeCheckResult = ((SystemGraphComponents.UpgradeChecker)this.resolver.resolveDependency(SystemGraphComponents.UpgradeChecker.class)).upgradeCheck();
        if (!upgradeCheckResult.upgradeAllowed()) {
            this.log.info("Upgrade not currently possible: %s", new Object[]{upgradeCheckResult.whyUpgradeNotAllowed()});
            return Stream.of(new SystemGraphComponentUpgradeResult("CANNOT_UPGRADE", upgradeCheckResult.whyUpgradeNotAllowed()));
        }
        SystemGraphComponents components = this.systemGraphComponents;
        SystemGraphComponent.Status status = components.detect((GraphDatabaseService)this.graph);
        if (BuiltInDbmsProcedures.isUpgradeable(status)) {
            Config config = (Config)this.graph.getDependencyResolver().resolveDependency(Config.class);
            if (this.graph.dbmsInfo().edition != Edition.COMMUNITY && ((Boolean)config.get(GraphDatabaseInternalSettings.automatic_upgrade_enabled)).booleanValue()) {
                Clock clock;
                Duration timeout = (Duration)config.get(GraphDatabaseInternalSettings.upgrade_procedure_wait_timeout);
                SystemGraphComponent.Status laterStatus = BuiltInDbmsProcedures.waitForUpgrade(() -> components.detect((GraphDatabaseService)this.graph), timeout, clock = (Clock)this.resolver.resolveDependency(Clock.class), this.log);
                if (BuiltInDbmsProcedures.isUpgradeable(laterStatus)) {
                    return Stream.of(new SystemGraphComponentUpgradeResult(laterStatus.name(), UPGRADE_PENDING_RESULT));
                }
                return Stream.of(new SystemGraphComponentUpgradeResult(laterStatus.name(), laterStatus.resolution()));
            }
            ArrayList failed = new ArrayList();
            components.forEach(component -> {
                SystemGraphComponent.Status initialStatus = component.detect((GraphDatabaseService)this.graph);
                if (BuiltInDbmsProcedures.isUpgradeable(initialStatus)) {
                    try {
                        component.upgradeToCurrent((GraphDatabaseService)this.graph);
                    }
                    catch (Exception e) {
                        failed.add(String.format("[%s] %s", component.componentName(), e.getMessage()));
                    }
                }
            });
            String upgradeResult = failed.isEmpty() ? "Success" : "Failed: " + String.join((CharSequence)", ", failed);
            return Stream.of(new SystemGraphComponentUpgradeResult(components.detect(this.transaction).name(), upgradeResult));
        }
        return Stream.of(new SystemGraphComponentUpgradeResult(status.name(), status.resolution()));
    }

    @SystemProcedure
    @Description(value="List all accepted network connections at this instance that are visible to the user.")
    @Procedure(name="dbms.listConnections", mode=Mode.DBMS)
    public Stream<ListConnectionResult> listConnections() {
        NetworkConnectionTracker connectionTracker = this.getConnectionTracker();
        ZoneId timeZone = this.getConfiguredTimeZone();
        return connectionTracker.activeConnections().stream().filter(connection -> this.isAdminOrSelf(connection.username())).map(connection -> new ListConnectionResult((TrackedNetworkConnection)connection, timeZone));
    }

    @SystemProcedure
    @Description(value="Kill network connection with the given connection id.")
    @Procedure(name="dbms.killConnection", mode=Mode.DBMS)
    public Stream<ConnectionTerminationResult> killConnection(@Name(value="id", description="The id of the connection to kill.") String id) {
        return this.killConnections(Collections.singletonList(id));
    }

    @SystemProcedure
    @Description(value="Kill all network connections with the given connection ids.")
    @Procedure(name="dbms.killConnections", mode=Mode.DBMS)
    public Stream<ConnectionTerminationResult> killConnections(@Name(value="ids", description="The ids of the connections to kill.") List<String> ids) {
        NetworkConnectionTracker connectionTracker = this.getConnectionTracker();
        return ids.stream().map(id -> this.killConnection((String)id, connectionTracker));
    }

    @Admin
    @Internal
    @SystemProcedure
    @Description(value="List all capabilities including internals")
    @Procedure(name="dbms.listAllCapabilities", mode=Mode.DBMS)
    public Stream<CapabilityResult> listAllCapabilities() {
        CapabilitiesService service = (CapabilitiesService)this.resolver.resolveDependency(CapabilitiesService.class);
        Collection capabilities = service.declaredCapabilities();
        return capabilities.stream().map(c -> new CapabilityResult((Capability<?>)c, service.get(c.name())));
    }

    @SystemProcedure
    @Description(value="List capabilities.")
    @Procedure(name="dbms.listCapabilities", mode=Mode.DBMS)
    public Stream<CapabilityResult> listCapabilities() {
        CapabilitiesService service = (CapabilitiesService)this.resolver.resolveDependency(CapabilitiesService.class);
        Collection capabilities = service.declaredCapabilities();
        return capabilities.stream().filter(c -> !c.internal()).map(c -> new CapabilityResult((Capability<?>)c, service.get(c.name())));
    }

    private NetworkConnectionTracker getConnectionTracker() {
        return (NetworkConnectionTracker)this.resolver.resolveDependency(NetworkConnectionTracker.class);
    }

    private ConnectionTerminationResult killConnection(String id, NetworkConnectionTracker connectionTracker) {
        TrackedNetworkConnection connection = connectionTracker.get(id);
        if (connection != null) {
            if (this.isAdminOrSelf(connection.username())) {
                connection.close();
                return new ConnectionTerminationResult(id, connection.username());
            }
            throw this.kernelTransaction.securityAuthorizationHandler().logAndGetAuthorizationException(this.securityContext, String.format("Not allowed to terminate connection for user %s.", connection.username()));
        }
        return new ConnectionTerminationFailedResult(id);
    }

    private boolean isAdminOrSelf(String username) {
        return this.securityContext.allowExecuteAdminProcedure(this.callContext.id()).allowsAccess() || this.securityContext.subject().hasUsername(username);
    }

    private GraphDatabaseAPI getSystemDatabase() {
        return (GraphDatabaseAPI)((DatabaseManagementService)this.graph.getDependencyResolver().resolveDependency(DatabaseManagementService.class)).database("system");
    }

    private static StoreIdProvider getSystemDatabaseStoreIdProvider(GraphDatabaseAPI databaseAPI) {
        return (StoreIdProvider)databaseAPI.getDependencyResolver().resolveDependency(StoreIdProvider.class);
    }

    private DatabaseContextProvider<DatabaseContext> getDatabaseManager() {
        return (DatabaseContextProvider)this.resolver.resolveDependency(DatabaseContextProvider.class);
    }

    private ZoneId getConfiguredTimeZone() {
        Config config = (Config)this.graph.getDependencyResolver().resolveDependency(Config.class);
        return ((LogTimeZone)config.get(GraphDatabaseSettings.db_timezone)).getZoneId();
    }

    public static SystemGraphComponentStatusResult getAggregateUpgradeStatus(SystemGraphComponents systemGraphComponents, DependencyResolver resolver, Transaction transaction) {
        SystemGraphComponents.UpgradeChecker checker = (SystemGraphComponents.UpgradeChecker)resolver.resolveDependency(SystemGraphComponents.UpgradeChecker.class);
        SystemGraphComponents.UpgradeCheckResult checkResult = checker.upgradeCheck();
        if (!checkResult.upgradeAllowed()) {
            return new SystemGraphComponentStatusResult("CANNOT_UPGRADE", checkResult.whyUpgradeNotAllowed(), "Wait for upgraded versions to be observed, or upgrade other cluster members so all are on the same version.");
        }
        return new SystemGraphComponentStatusResult(systemGraphComponents.detect(transaction));
    }

    public static boolean isUpgradeable(SystemGraphComponent.Status status) {
        return List.of(SystemGraphComponent.Status.REQUIRES_UPGRADE, SystemGraphComponent.Status.UNINITIALIZED).contains(status);
    }

    public static SystemGraphComponent.Status waitForUpgrade(Supplier<SystemGraphComponent.Status> statusSupplier, Duration waitDuration, Clock clock, Log log) {
        long timeout = clock.millis() + waitDuration.toMillis();
        while (clock.millis() < timeout) {
            SystemGraphComponent.Status status = statusSupplier.get();
            if (!BuiltInDbmsProcedures.isUpgradeable(status)) {
                return status;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                log.info("Wait for upgrade to complete was interrupted", (Throwable)e);
            }
        }
        return statusSupplier.get();
    }

    public record SystemInfo(@Description(value="The id of the DBMS.") String id, @Description(value="The name of the DBMS.") String name, @Description(value="The creation date of the DBMS.") String creationDate) {
    }

    public static class StringResult {
        @Description(value="Information about the number of cleared query caches.")
        public final String value;

        public StringResult(String value) {
            this.value = value;
        }
    }

    public record SystemGraphComponentStatusResult(@Description(value="The upgrade status of the system database.") String status, @Description(value="Information describing the upgrade status.") String description, @Description(value="Information about the steps necessary to upgrade.") String resolution) {
        public static final String CANNOT_UPGRADE_STATUS = "CANNOT_UPGRADE";
        public static final String CANNOT_UPGRADE_RESOLUTION = "Wait for upgraded versions to be observed, or upgrade other cluster members so all are on the same version.";

        SystemGraphComponentStatusResult(SystemGraphComponent.Status status) {
            this(status.name(), status.description(), status.resolution());
        }
    }

    public static class SystemGraphComponentUpgradeResult {
        @Description(value="The upgrade status of the system database.")
        public final String status;
        @Description(value="Information about the upgrade outcome.")
        public final String upgradeResult;

        SystemGraphComponentUpgradeResult(String status, String upgradeResult) {
            this.status = status;
            this.upgradeResult = upgradeResult;
        }
    }

    public static class MetadataResult {
        @Description(value="Metadata about the transaction.")
        public final Map<String, Object> metadata;

        MetadataResult(Map<String, Object> metadata) {
            this.metadata = metadata;
        }
    }
}

