/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.driver;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public final class TypeAdapterLookupDelegate {
    private final Map<Class<?>, Function> registeredTypeAdapter;

    public TypeAdapterLookupDelegate(Map<Class<?>, Function> registeredTypeAdapter) {
        this.registeredTypeAdapter = Collections.unmodifiableMap(registeredTypeAdapter);
    }

    public Function<Object, Object> getAdapterFor(Class<?> clazz) {
        Function adapter = this.findAdapterFor(clazz).orElseGet(Function::identity);
        return object -> object == null ? null : adapter.apply(object);
    }

    public boolean hasAdapterFor(Class<?> clazz) {
        return this.findAdapterFor(clazz).isPresent();
    }

    private Optional<Function<Object, Object>> findAdapterFor(Class<?> clazz) {
        if (clazz == null) {
            return Optional.empty();
        }
        if (this.registeredTypeAdapter.containsKey(clazz)) {
            return Optional.of(this.registeredTypeAdapter.get(clazz));
        }
        return this.registeredTypeAdapter.entrySet().stream().filter(e -> ((Class)e.getKey()).isAssignableFrom(clazz)).findFirst().map(Map.Entry::getValue);
    }
}

