/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.management.impl;

import javax.management.NotCompliantMBeanException;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.impl.transaction.TxModule;
import org.neo4j.management.TransactionManager;
import org.neo4j.management.impl.Description;
import org.neo4j.management.impl.ManagementBeanProvider;
import org.neo4j.management.impl.Neo4jMBean;

public final class TransactionManagerBean
extends ManagementBeanProvider {
    public TransactionManagerBean() {
        super(TransactionManager.class);
    }

    @Override
    protected Neo4jMBean createMBean(KernelData kernel) throws NotCompliantMBeanException {
        return new TransactionManagerImpl(this, kernel);
    }

    @Description(value="Information about the Neo4j transaction manager")
    private static class TransactionManagerImpl
    extends Neo4jMBean
    implements TransactionManager {
        private final TxModule txModule;

        TransactionManagerImpl(ManagementBeanProvider provider, KernelData kernel) throws NotCompliantMBeanException {
            super(provider, kernel);
            this.txModule = kernel.getConfig().getTxModule();
        }

        @Override
        @Description(value="The number of currently open transactions")
        public int getNumberOfOpenTransactions() {
            return this.txModule.getActiveTxCount();
        }

        @Override
        @Description(value="The highest number of transactions ever opened concurrently")
        public int getPeakNumberOfConcurrentTransactions() {
            return this.txModule.getPeakConcurrentTxCount();
        }

        @Override
        @Description(value="The total number started transactions")
        public int getNumberOfOpenedTransactions() {
            return this.txModule.getStartedTxCount();
        }

        @Override
        @Description(value="The total number of committed transactions")
        public long getNumberOfCommittedTransactions() {
            return this.txModule.getCommittedTxCount();
        }

        @Override
        @Description(value="The total number of rolled back transactions")
        public long getNumberOfRolledBackTransactions() {
            return this.txModule.getRolledbackTxCount();
        }
    }
}

