/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.management.impl;

import java.io.File;
import java.io.IOException;
import javax.management.NotCompliantMBeanException;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.management.StoreFile;
import org.neo4j.management.impl.Description;
import org.neo4j.management.impl.KernelBean;
import org.neo4j.management.impl.ManagementBeanProvider;
import org.neo4j.management.impl.Neo4jMBean;

public final class StoreFileBean
extends ManagementBeanProvider {
    public StoreFileBean() {
        super(StoreFile.class);
    }

    @Override
    protected Neo4jMBean createMBean(KernelData kernel) throws NotCompliantMBeanException {
        return new StoreFileImpl(this, kernel);
    }

    @Description(value="Information about the sizes of the different parts of the Neo4j graph store")
    private static class StoreFileImpl
    extends Neo4jMBean
    implements StoreFile {
        private static final String NODE_STORE = "neostore.nodestore.db";
        private static final String RELATIONSHIP_STORE = "neostore.relationshipstore.db";
        private static final String PROPERTY_STORE = "neostore.propertystore.db";
        private static final String ARRAY_STORE = "neostore.propertystore.db.arrays";
        private static final String STRING_STORE = "neostore.propertystore.db.strings";
        private static final String LOGICAL_LOG1 = "nioneo_logical.log.1";
        private static final String LOGICAL_LOG2 = "nioneo_logical.log.2";
        private final File storePath;

        StoreFileImpl(ManagementBeanProvider provider, KernelData kernel) throws NotCompliantMBeanException {
            super(provider, kernel);
            File path;
            NeoStoreXaDataSource nioneodb = KernelBean.getNeoDataSource(kernel);
            try {
                path = new File(nioneodb.getStoreDir()).getCanonicalFile().getAbsoluteFile();
            }
            catch (IOException e) {
                path = new File(nioneodb.getStoreDir()).getAbsoluteFile();
            }
            this.storePath = path;
        }

        @Override
        @Description(value="The total disk space used by this Neo4j instance, in bytes.")
        public long getTotalStoreSize() {
            return StoreFileImpl.sizeOf(this.storePath);
        }

        @Override
        @Description(value="The amount of disk space used by the current Neo4j logical log, in bytes.")
        public long getLogicalLogSize() {
            File logicalLog = new File(this.storePath, LOGICAL_LOG1);
            if (!logicalLog.isFile()) {
                logicalLog = new File(this.storePath, LOGICAL_LOG2);
            }
            return StoreFileImpl.sizeOf(logicalLog);
        }

        private static long sizeOf(File file) {
            if (file.isFile()) {
                return file.length();
            }
            if (file.isDirectory()) {
                long size = 0L;
                for (File child : file.listFiles()) {
                    size += StoreFileImpl.sizeOf(child);
                }
                return size;
            }
            return 0L;
        }

        private long sizeOf(String name) {
            return StoreFileImpl.sizeOf(new File(this.storePath, name));
        }

        @Override
        @Description(value="The amount of disk space used to store array properties, in bytes.")
        public long getArrayStoreSize() {
            return this.sizeOf(ARRAY_STORE);
        }

        @Override
        @Description(value="The amount of disk space used to store nodes, in bytes.")
        public long getNodeStoreSize() {
            return this.sizeOf(NODE_STORE);
        }

        @Override
        @Description(value="The amount of disk space used to store properties (excluding string values and array values), in bytes.")
        public long getPropertyStoreSize() {
            return this.sizeOf(PROPERTY_STORE);
        }

        @Override
        @Description(value="The amount of disk space used to store relationships, in bytes.")
        public long getRelationshipStoreSize() {
            return this.sizeOf(RELATIONSHIP_STORE);
        }

        @Override
        @Description(value="The amount of disk space used to store string properties, in bytes.")
        public long getStringStoreSize() {
            return this.sizeOf(STRING_STORE);
        }
    }
}

