/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.management.impl;

import javax.management.NotCompliantMBeanException;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.management.Primitives;
import org.neo4j.management.impl.Description;
import org.neo4j.management.impl.ManagementBeanProvider;
import org.neo4j.management.impl.Neo4jMBean;

public final class PrimitivesBean
extends ManagementBeanProvider {
    public PrimitivesBean() {
        super(Primitives.class);
    }

    @Override
    protected Neo4jMBean createMBean(KernelData kernel) throws NotCompliantMBeanException {
        return new PrimitivesImpl(this, kernel);
    }

    @Description(value="Estimates of the numbers of different kinds of Neo4j primitives")
    private static class PrimitivesImpl
    extends Neo4jMBean
    implements Primitives {
        private final NodeManager nodeManager;

        protected PrimitivesImpl(ManagementBeanProvider provider, KernelData kernel) throws NotCompliantMBeanException {
            super(provider, kernel);
            this.nodeManager = kernel.getConfig().getGraphDbModule().getNodeManager();
        }

        @Override
        @Description(value="An estimation of the number of nodes used in this Neo4j instance")
        public long getNumberOfNodeIdsInUse() {
            return this.nodeManager.getNumberOfIdsInUse(Node.class);
        }

        @Override
        @Description(value="An estimation of the number of relationships used in this Neo4j instance")
        public long getNumberOfRelationshipIdsInUse() {
            return this.nodeManager.getNumberOfIdsInUse(Relationship.class);
        }

        @Override
        @Description(value="An estimation of the number of properties used in this Neo4j instance")
        public long getNumberOfPropertyIdsInUse() {
            return this.nodeManager.getNumberOfIdsInUse(PropertyStore.class);
        }

        @Override
        @Description(value="The number of relationship types used in this Neo4j instance")
        public long getNumberOfRelationshipTypeIdsInUse() {
            return this.nodeManager.getNumberOfIdsInUse(RelationshipType.class);
        }
    }
}

