/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.management.impl;

import javax.management.MBeanAttributeInfo;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.neo4j.kernel.KernelData;
import org.neo4j.management.Kernel;
import org.neo4j.management.impl.Description;
import org.neo4j.management.impl.JmxExtension;
import org.neo4j.management.impl.ManagementBeanProvider;

public class Neo4jMBean
extends StandardMBean {
    final ObjectName objectName;

    protected Neo4jMBean(ManagementBeanProvider provider, KernelData kernel, boolean isMXBean) {
        super(provider.beanInterface, isMXBean);
        this.objectName = provider.getObjectName(kernel);
    }

    protected Neo4jMBean(ManagementBeanProvider provider, KernelData kernel) throws NotCompliantMBeanException {
        super(provider.beanInterface);
        this.objectName = provider.getObjectName(kernel);
    }

    Neo4jMBean(Class<Kernel> beenInterface, KernelData kernel) throws NotCompliantMBeanException {
        super(beenInterface);
        this.objectName = JmxExtension.getObjectName(kernel, beenInterface, null);
    }

    @Override
    protected String getClassName(MBeanInfo info) {
        Class<?> iface = this.getMBeanInterface();
        return iface == null ? info.getClassName() : iface.getName();
    }

    @Override
    protected String getDescription(MBeanInfo info) {
        Description description = this.getClass().getAnnotation(Description.class);
        if (description != null) {
            return description.value();
        }
        return super.getDescription(info);
    }

    @Override
    protected String getDescription(MBeanAttributeInfo info) {
        Description description = this.describeMethod(info, "get", "is");
        if (description != null) {
            return description.value();
        }
        return super.getDescription(info);
    }

    @Override
    protected String getDescription(MBeanOperationInfo info) {
        Description description = this.describeMethod(info, new String[0]);
        if (description != null) {
            return description.value();
        }
        return super.getDescription(info);
    }

    @Override
    protected int getImpact(MBeanOperationInfo info) {
        Description description = this.describeMethod(info, new String[0]);
        if (description != null) {
            return description.impact();
        }
        return super.getImpact(info);
    }

    private Description describeMethod(MBeanFeatureInfo info, String ... prefixes) {
        if (prefixes == null || prefixes.length == 0) {
            try {
                return this.getClass().getMethod(info.getName(), new Class[0]).getAnnotation(Description.class);
            }
            catch (Exception e) {
                return null;
            }
        }
        for (String prefix : prefixes) {
            try {
                return this.getClass().getMethod(prefix + info.getName(), new Class[0]).getAnnotation(Description.class);
            }
            catch (Exception e) {
            }
        }
        return null;
    }
}

