/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.management.impl;

import java.util.Iterator;
import java.util.List;
import javax.management.NotCompliantMBeanException;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.impl.nioneo.store.WindowPoolStats;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.management.MemoryMapping;
import org.neo4j.management.WindowPoolInfo;
import org.neo4j.management.impl.Description;
import org.neo4j.management.impl.KernelBean;
import org.neo4j.management.impl.ManagementBeanProvider;
import org.neo4j.management.impl.Neo4jMBean;

public final class MemoryMappingBean
extends ManagementBeanProvider {
    public MemoryMappingBean() {
        super(MemoryMapping.class);
    }

    @Override
    protected Neo4jMBean createMBean(KernelData kernel) throws NotCompliantMBeanException {
        return new MemoryMappingImpl(this, kernel);
    }

    @Override
    protected Neo4jMBean createMXBean(KernelData kernel) throws NotCompliantMBeanException {
        return new MemoryMappingImpl(this, kernel, true);
    }

    @Description(value="The status of Neo4j memory mapping")
    private static class MemoryMappingImpl
    extends Neo4jMBean
    implements MemoryMapping {
        private final NeoStoreXaDataSource datasource;

        MemoryMappingImpl(ManagementBeanProvider provider, KernelData kernel) throws NotCompliantMBeanException {
            super(provider, kernel);
            this.datasource = KernelBean.getNeoDataSource(kernel);
        }

        MemoryMappingImpl(ManagementBeanProvider provider, KernelData kernel, boolean isMxBean) {
            super(provider, kernel, isMxBean);
            XaDataSourceManager mgr = kernel.getConfig().getTxModule().getXaDataSourceManager();
            this.datasource = (NeoStoreXaDataSource)mgr.getXaDataSource("nioneodb");
        }

        @Override
        @Description(value="Get information about each pool of memory mapped regions from store files with memory mapping enabled")
        public WindowPoolInfo[] getMemoryPools() {
            return MemoryMappingImpl.getMemoryPoolsImpl(this.datasource);
        }

        public static WindowPoolInfo[] getMemoryPoolsImpl(NeoStoreXaDataSource datasource) {
            List stats = datasource.getWindowPoolStats();
            WindowPoolInfo[] pools = new WindowPoolInfo[stats.size()];
            Iterator iter = stats.iterator();
            int index = 0;
            while (iter.hasNext()) {
                pools[index] = MemoryMappingImpl.createWindowPoolInfo((WindowPoolStats)iter.next());
                ++index;
            }
            return pools;
        }

        private static WindowPoolInfo createWindowPoolInfo(WindowPoolStats stats) {
            return new WindowPoolInfo(stats.getName(), stats.getMemAvail(), stats.getMemUsed(), stats.getWindowCount(), stats.getWindowSize(), stats.getHitCount(), stats.getMissCount(), stats.getOomCount());
        }
    }
}

