/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.management.impl;

import javax.management.DynamicMBean;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.neo4j.helpers.Service;
import org.neo4j.kernel.KernelData;
import org.neo4j.management.impl.BeanProxy;
import org.neo4j.management.impl.JmxExtension;
import org.neo4j.management.impl.Neo4jMBean;

public abstract class ManagementBeanProvider
extends Service {
    final Class<?> beanInterface;
    private final String beanName;

    public ManagementBeanProvider(Class<?> beanInterface) {
        this(ManagementBeanProvider.beanName(beanInterface), beanInterface);
    }

    ManagementBeanProvider(String beanName) {
        this(beanName, DynamicMBean.class);
    }

    private ManagementBeanProvider(String beanName, Class<?> beanInterface) {
        super(beanName, new String[0]);
        this.beanName = beanName;
        this.beanInterface = beanInterface;
    }

    private static String beanName(Class<?> iface) {
        if (iface.isInterface()) {
            try {
                return (String)iface.getField("NAME").get(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException(iface + " is not a Neo4j Management Been interface");
    }

    protected abstract Neo4jMBean createMBean(KernelData var1) throws NotCompliantMBeanException;

    protected Neo4jMBean createMXBean(KernelData kernel) throws NotCompliantMBeanException {
        return this.createMBean(kernel);
    }

    Neo4jMBean loadBeen(KernelData kernel) {
        try {
            if (BeanProxy.supportsMxBeans()) {
                return this.createMXBean(kernel);
            }
            return this.createMBean(kernel);
        }
        catch (Exception e) {
            return null;
        }
    }

    ObjectName getObjectName(KernelData kernel) {
        ObjectName name = JmxExtension.getObjectName(kernel, this.beanInterface, this.beanName);
        if (name == null) {
            throw new IllegalArgumentException(this.beanInterface + " is not a Neo4j Management Bean interface");
        }
        return name;
    }
}

