/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.management.impl;

import javax.management.NotCompliantMBeanException;
import org.neo4j.kernel.KernelData;
import org.neo4j.management.LockManager;
import org.neo4j.management.impl.Description;
import org.neo4j.management.impl.ManagementBeanProvider;
import org.neo4j.management.impl.Neo4jMBean;

public final class LockManagerBean
extends ManagementBeanProvider {
    public LockManagerBean() {
        super(LockManager.class);
    }

    @Override
    protected Neo4jMBean createMBean(KernelData kernel) throws NotCompliantMBeanException {
        return new LockManagerImpl(this, kernel);
    }

    @Description(value="Information about the Neo4j lock status")
    private static class LockManagerImpl
    extends Neo4jMBean
    implements LockManager {
        private final org.neo4j.kernel.impl.transaction.LockManager lockManager;

        LockManagerImpl(ManagementBeanProvider provider, KernelData kernel) throws NotCompliantMBeanException {
            super(provider, kernel);
            this.lockManager = kernel.getConfig().getLockManager();
        }

        @Override
        @Description(value="The number of lock sequences that would have lead to a deadlock situation that Neo4j has detected and adverted (by throwing DeadlockDetectedException).")
        public long getNumberOfAdvertedDeadlocks() {
            return this.lockManager.getDetectedDeadlockCount();
        }
    }
}

