/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.management.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.remote.JMXServiceURL;
import org.neo4j.kernel.KernelData;
import org.neo4j.management.Kernel;
import org.neo4j.management.impl.BeanNaming;
import org.neo4j.management.impl.BeanProxy;
import org.neo4j.management.impl.JmxExtension;

public abstract class KernelProxy {
    protected final MBeanServerConnection server;
    protected final Kernel kernel;

    protected KernelProxy(MBeanServerConnection server, Kernel kernel) {
        this.server = server;
        this.kernel = kernel;
    }

    protected static ObjectName getObjectName(Class<?> beanType, String kernelIdentifier) {
        return BeanNaming.getObjectName(kernelIdentifier, beanType, null);
    }

    protected static <T> T proxy(MBeanServerConnection server, Class<T> beanType, ObjectName name) {
        return BeanProxy.load(server, beanType, name);
    }

    public List<Object> allBeans() {
        Set<ObjectInstance> mbeans;
        ArrayList<Object> beans = new ArrayList<Object>();
        try {
            mbeans = this.server.queryMBeans(this.kernel.getMBeanQuery(), null);
        }
        catch (IOException handled) {
            return beans;
        }
        block6: for (ObjectInstance instance : mbeans) {
            String className = instance.getClassName();
            Class<?> beanType = null;
            try {
                if (className != null) {
                    beanType = Class.forName(className);
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            block7: while (beanType != null && beanType != Kernel.class) {
                try {
                    beans.add(BeanProxy.load(this.server, beanType, instance.getObjectName()));
                    continue block6;
                }
                catch (IllegalArgumentException couldNotCreateProxy) {
                    Class<?>[] interfaces = beanType.getInterfaces();
                    if (interfaces.length == 0) {
                        beanType = beanType.getSuperclass();
                        continue;
                    }
                    for (Class<?> type : interfaces) {
                        if (!type.getName().equals(beanType.getName() + "MBean")) continue;
                        beanType = type;
                        continue block7;
                    }
                    continue block6;
                }
            }
        }
        return beans;
    }

    protected ObjectName getObjectName(String beanName) {
        return this.assertExists(BeanNaming.getObjectName(this.kernel.getMBeanQuery(), null, beanName));
    }

    protected ObjectName getObjectName(Class<?> beanInterface) {
        return this.assertExists(BeanNaming.getObjectName(this.kernel.getMBeanQuery(), beanInterface, null));
    }

    private ObjectName assertExists(ObjectName name) {
        try {
            if (!this.server.queryNames(name, null).isEmpty()) {
                return name;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw new NoSuchElementException("No MBeans matching " + name);
    }

    protected <T> T getBean(Class<T> beanInterface) {
        return BeanProxy.load(this.server, beanInterface, this.getObjectName(beanInterface));
    }

    protected static JMXServiceURL getConnectionURL(KernelData kernel) {
        return new JmxExtension().getConnectionURL(kernel);
    }
}

