/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.management.impl;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.management.Kernel;
import org.neo4j.management.impl.Description;
import org.neo4j.management.impl.JmxExtension;
import org.neo4j.management.impl.Neo4jMBean;

@Description(value="Information about the Neo4j kernel")
class KernelBean
extends Neo4jMBean
implements Kernel {
    private final long kernelStartTime;
    private final long storeCreationDate;
    private final long storeId;
    private final long storeLogVersion;
    private final boolean isReadOnly;
    private final String kernelVersion;
    private final String storeDir;
    private final ObjectName query;

    KernelBean(KernelData kernel) throws NotCompliantMBeanException {
        super(Kernel.class, kernel);
        String storeDir;
        NeoStoreXaDataSource datasource = KernelBean.getNeoDataSource(kernel);
        this.kernelVersion = kernel.version().toString();
        this.query = JmxExtension.getObjectName(kernel, null, null);
        this.storeCreationDate = datasource.getCreationTime();
        this.storeLogVersion = datasource.getCurrentLogVersion();
        this.isReadOnly = datasource.isReadOnly();
        this.storeId = datasource.getRandomIdentifier();
        try {
            storeDir = new File(datasource.getStoreDir()).getCanonicalFile().getAbsolutePath();
        }
        catch (IOException e) {
            storeDir = new File(datasource.getStoreDir()).getAbsolutePath();
        }
        this.storeDir = storeDir;
        this.kernelStartTime = new Date().getTime();
    }

    static NeoStoreXaDataSource getNeoDataSource(KernelData kernel) {
        XaDataSourceManager mgr = kernel.getConfig().getTxModule().getXaDataSourceManager();
        return (NeoStoreXaDataSource)mgr.getXaDataSource("nioneodb");
    }

    @Override
    @Description(value="An ObjectName that can be used as a query for getting all management beans for this Neo4j instance.")
    public ObjectName getMBeanQuery() {
        return this.query;
    }

    @Override
    @Description(value="The time from which this Neo4j instance was in operational mode.")
    public Date getKernelStartTime() {
        return new Date(this.kernelStartTime);
    }

    @Override
    @Description(value="The time when this Neo4j graph store was created.")
    public Date getStoreCreationDate() {
        return new Date(this.storeCreationDate);
    }

    @Override
    @Description(value="An identifier that uniquely identifies this Neo4j graph store.")
    public String getStoreId() {
        return Long.toHexString(this.storeId);
    }

    @Override
    @Description(value="The current version of the Neo4j store logical log.")
    public long getStoreLogVersion() {
        return this.storeLogVersion;
    }

    @Override
    @Description(value="The version of Neo4j")
    public String getKernelVersion() {
        return this.kernelVersion;
    }

    @Override
    @Description(value="Whether this is a read only instance")
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    @Description(value="The location where the Neo4j store is located")
    public String getStoreDirectory() {
        return this.storeDir;
    }
}

