/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.management.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.ReflectionException;
import org.neo4j.kernel.KernelData;
import org.neo4j.management.impl.Description;
import org.neo4j.management.impl.ManagementBeanProvider;
import org.neo4j.management.impl.Neo4jMBean;

public final class ConfigurationBean
extends ManagementBeanProvider {
    public static final String CONFIGURATION_MBEAN_NAME = "Configuration";
    @Description(value="Tell Neo4j to use memory mapped buffers for accessing the native storage layer")
    public static final String USE_MEMORY_MAPPED_BUFFERS = "use_memory_mapped_buffers";
    @Description(value="Print out the effective Neo4j configuration after startup")
    public static final String DUMP_CONFIGURATION = "dump_configuration";
    @Description(value="Make Neo4j keep the logical transaction logs for being able to backup the database")
    public static final String KEEP_LOGICAL_LOGS = "keep_logical_logs";
    @Description(value="Enable a remote shell server which shell clients can log in to")
    public static final String ENABLE_REMOTE_SHELL = "enable_remote_shell";
    @Description(value="<TODO: document this>")
    public static final String BACKUP_SLAVE = "backup_slave";
    @Description(value="Only allow read operations from this Neo4j instance")
    public static final String READ_ONLY = "read_only";
    @Description(value="Relative path for where the Neo4j storage directory is located")
    public static final String STORAGE_DIRECTORY = "store_dir";
    @Description(value="Use a quick approach for rebuilding the ID generators. This give quicker recovery time, but will limit the ability to reuse the space of deleted entities.")
    public static final String REBUILD_IDGENERATORS_FAST = "rebuild_idgenerators_fast";
    @Description(value="The size to allocate for memory mapping the node store")
    public static final String NODE_STORE_MMAP_SIZE = "neostore.nodestore.db.mapped_memory";
    @Description(value="The size to allocate for memory mapping the array property store")
    public static final String ARRAY_PROPERTY_STORE_MMAP_SIZE = "neostore.propertystore.db.arrays.mapped_memory";
    @Description(value="The size to allocate for memory mapping the store for property key strings")
    public static final String PROPERTY_INDEX_KEY_STORE_MMAP_SIZE = "neostore.propertystore.db.index.keys.mapped_memory";
    @Description(value="The size to allocate for memory mapping the store for property key indexes")
    public static final String PROPERTY_INDEX_STORE_MMAP_SIZE = "neostore.propertystore.db.index.mapped_memory";
    @Description(value="The size to allocate for memory mapping the property value store")
    public static final String PROPERTY_STORE_MMAP_SIZE = "neostore.propertystore.db.mapped_memory";
    @Description(value="The size to allocate for memory mapping the string property store")
    public static final String STRING_PROPERTY_STORE_MMAP_SIZE = "neostore.propertystore.db.strings.mapped_memory";
    @Description(value="The size to allocate for memory mapping the relationship store")
    public static final String RELATIONSHIP_STORE_MMAP_SIZE = "neostore.relationshipstore.db.mapped_memory";
    @Description(value="Relative path for where the Neo4j logical log is located")
    public static final String LOGICAL_LOG = "logical_log";
    @Description(value="Relative path for where the Neo4j storage information file is located")
    public static final String NEO_STORE = "neo_store";
    @Description(value="The type of cache to use for nodes and relationships, one of [weak, soft, none]")
    public static final String CACHE_TYPE = "cache_type";

    public ConfigurationBean() {
        super(CONFIGURATION_MBEAN_NAME);
    }

    @Override
    protected Neo4jMBean createMBean(KernelData kernel) throws NotCompliantMBeanException {
        return new ConfigurationImpl(this, kernel);
    }

    @Description(value="The configuration parameters used to configure Neo4j")
    private static class ConfigurationImpl
    extends Neo4jMBean {
        private static final Map<String, String> parameterDescriptions;
        private final Map<Object, Object> config;

        protected ConfigurationImpl(ManagementBeanProvider provider, KernelData kernel) throws NotCompliantMBeanException {
            super(provider, kernel);
            this.config = kernel.getConfigParams();
        }

        private static String describeConfigParameter(String param) {
            String description = parameterDescriptions.get(param);
            return description != null ? description : "Configuration attribute";
        }

        private MBeanAttributeInfo[] keys() {
            ArrayList<MBeanAttributeInfo> keys = new ArrayList<MBeanAttributeInfo>();
            for (Map.Entry<Object, Object> entry : this.config.entrySet()) {
                if (!(entry.getKey() instanceof String)) continue;
                keys.add(new MBeanAttributeInfo((String)entry.getKey(), String.class.getName(), ConfigurationImpl.describeConfigParameter((String)entry.getKey()), true, false, false));
            }
            return keys.toArray(new MBeanAttributeInfo[keys.size()]);
        }

        @Override
        public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
            return this.config.get(attribute);
        }

        @Override
        public AttributeList getAttributes(String[] attributes) {
            AttributeList result = new AttributeList(attributes.length);
            for (String attribute : attributes) {
                try {
                    result.add(this.getAttribute(attribute));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return result;
        }

        @Override
        public MBeanInfo getMBeanInfo() {
            Description description = this.getClass().getAnnotation(Description.class);
            return new MBeanInfo(this.getClass().getName(), description != null ? description.value() : "Neo4j configuration", this.keys(), null, null, null);
        }

        static {
            HashMap<String, String> descriptions = new HashMap<String, String>();
            for (Field field : ConfigurationBean.class.getFields()) {
                Description descr;
                if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers()) || (descr = field.getAnnotation(Description.class)) == null || field.getType() != String.class) continue;
                try {
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    descriptions.put((String)field.get(null), descr.value());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            parameterDescriptions = Collections.unmodifiableMap(descriptions);
        }
    }
}

