/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.management.impl;

import javax.management.NotCompliantMBeanException;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.management.Cache;
import org.neo4j.management.impl.Description;
import org.neo4j.management.impl.ManagementBeanProvider;
import org.neo4j.management.impl.Neo4jMBean;

public class CacheBean
extends ManagementBeanProvider {
    public CacheBean() {
        super(Cache.class);
    }

    @Override
    protected Neo4jMBean createMBean(KernelData kernel) throws NotCompliantMBeanException {
        return new CacheManager(this, kernel);
    }

    @Description(value="Information about the caching in Neo4j")
    private class CacheManager
    extends Neo4jMBean
    implements Cache {
        private final NodeManager nodeManager;

        CacheManager(ManagementBeanProvider provider, KernelData kernel) throws NotCompliantMBeanException {
            super(provider, kernel);
            this.nodeManager = kernel.getConfig().getGraphDbModule().getNodeManager();
        }

        @Override
        @Description(value="The type of cache used by Neo4j")
        public String getCacheType() {
            return this.nodeManager.getCacheType().getDescription();
        }

        @Override
        @Description(value="The number of Nodes currently in cache")
        public int getNodeCacheSize() {
            return this.nodeManager.getNodeCacheSize();
        }

        @Override
        @Description(value="The number of Relationships currently in cache")
        public int getRelationshipCacheSize() {
            return this.nodeManager.getRelationshipCacheSize();
        }

        @Override
        @Description(value="Clears the Neo4j caches", impact=1)
        public void clear() {
            this.nodeManager.clearCache();
        }
    }
}

