/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.management;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.net.MalformedURLException;
import javax.management.remote.JMXServiceURL;
import org.neo4j.helpers.Pair;
import org.neo4j.management.HighAvailability;
import org.neo4j.management.Neo4jManager;

public class InstanceInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String address;
    private final String instanceId;
    private final int machineId;
    private final boolean master;
    private final long lastTxId;

    @ConstructorProperties(value={"address", "instanceId", "machineId", "master", "lastCommittedTransactionId"})
    public InstanceInfo(String address, String instanceId, int machineId, boolean master, long lastTxId) {
        this.address = address;
        this.instanceId = instanceId;
        this.machineId = machineId;
        this.master = master;
        this.lastTxId = lastTxId;
    }

    public String toString() {
        return String.format("Neo4jHaInstance[id=%s,address=%s,machineId=%s,lastTxId=%s]", this.instanceId, this.address, this.machineId, this.lastTxId);
    }

    public boolean isMaster() {
        return this.master;
    }

    public String getAddress() {
        return this.address;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public int getMachineId() {
        return this.machineId;
    }

    public long getLastCommittedTransactionId() {
        return this.lastTxId;
    }

    public Pair<Neo4jManager, HighAvailability> connect() {
        return this.connect(null, null);
    }

    public Pair<Neo4jManager, HighAvailability> connect(String username, String password) {
        if (this.address == null) {
            throw new IllegalStateException("The instance does not have a public JMX server.");
        }
        Neo4jManager manager = Neo4jManager.get(this.url(), username, password, this.instanceId);
        return Pair.of((Object)manager, (Object)manager.getBean(HighAvailability.class));
    }

    private JMXServiceURL url() {
        try {
            return new JMXServiceURL(this.address);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("The instance does not have a valid JMX server URL.");
        }
    }
}

