/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.writer;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.kernel.api.impl.index.WritableDatabaseIndex;
import org.neo4j.kernel.api.impl.index.partition.AbstractIndexPartition;
import org.neo4j.kernel.api.impl.schema.writer.LuceneIndexWriter;

public class PartitionedIndexWriter
implements LuceneIndexWriter {
    private static final Integer DEFAULT_MAXIMUM_PARTITION_SIZE = 1932735168;
    private final WritableDatabaseIndex<?, ?> index;
    private final int maximumPartitionSize;

    public PartitionedIndexWriter(WritableDatabaseIndex<?, ?> index, Config config) {
        this.index = index;
        Integer configuredMaxPartitionSize = (Integer)config.get(GraphDatabaseInternalSettings.lucene_max_partition_size);
        this.maximumPartitionSize = Objects.requireNonNullElse(configuredMaxPartitionSize, DEFAULT_MAXIMUM_PARTITION_SIZE);
    }

    @Override
    public void addDocument(Document doc) throws IOException {
        this.getIndexWriter(1).addDocument((Iterable)doc);
    }

    @Override
    public void addDocuments(int numDocs, Iterable<Document> documents) throws IOException {
        this.getIndexWriter(numDocs).addDocuments(documents);
    }

    @Override
    public void updateDocument(Term term, Document doc) throws IOException {
        List partitions = this.index.getPartitions();
        if (WritableDatabaseIndex.hasSinglePartition(partitions) && this.writablePartition(WritableDatabaseIndex.getFirstPartition(partitions), 1)) {
            WritableDatabaseIndex.getFirstPartition(partitions).getIndexWriter().updateDocument(term, (Iterable)doc);
        } else {
            this.deleteDocuments(term);
            this.addDocument(doc);
        }
    }

    @Override
    public void deleteDocuments(Query query) throws IOException {
        List partitions = this.index.getPartitions();
        for (AbstractIndexPartition partition : partitions) {
            partition.getIndexWriter().deleteDocuments(new Query[]{query});
        }
    }

    @Override
    public void addDirectory(int count, Directory directory) throws IOException {
        this.getIndexWriter(count).addIndexes(new Directory[]{directory});
    }

    @Override
    public void deleteDocuments(Term term) throws IOException {
        List partitions = this.index.getPartitions();
        for (AbstractIndexPartition partition : partitions) {
            partition.getIndexWriter().deleteDocuments(new Term[]{term});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexWriter getIndexWriter(int numDocs) throws IOException {
        WritableDatabaseIndex<?, ?> writableDatabaseIndex = this.index;
        synchronized (writableDatabaseIndex) {
            return this.unsafeGetIndexWriter(numDocs);
        }
    }

    private IndexWriter unsafeGetIndexWriter(int numDocs) throws IOException {
        List indexPartitions = this.index.getPartitions();
        int size = indexPartitions.size();
        for (int i = 0; i < size; ++i) {
            AbstractIndexPartition partition = (AbstractIndexPartition)indexPartitions.get(i);
            if (!this.writablePartition(partition, numDocs)) continue;
            return partition.getIndexWriter();
        }
        AbstractIndexPartition indexPartition = this.index.addNewPartition();
        return indexPartition.getIndexWriter();
    }

    private boolean writablePartition(AbstractIndexPartition partition, int numDocs) {
        return this.maximumPartitionSize - partition.getIndexWriter().getDocStats().maxDoc >= numDocs;
    }
}

