/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.sampler;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.IndexSampler;

public class AggregatingIndexSampler
implements IndexSampler {
    private final List<IndexSampler> indexSamplers;

    public AggregatingIndexSampler(List<IndexSampler> indexSamplers) {
        this.indexSamplers = indexSamplers;
    }

    public IndexSample sampleIndex(CursorContext cursorContext, AtomicBoolean stopped) {
        return this.indexSamplers.parallelStream().map(sampler -> AggregatingIndexSampler.sampleIndex(sampler, cursorContext, stopped)).reduce(AggregatingIndexSampler::combine).get();
    }

    private static IndexSample sampleIndex(IndexSampler sampler, CursorContext cursorContext, AtomicBoolean stopped) {
        try {
            return sampler.sampleIndex(cursorContext, stopped);
        }
        catch (IndexNotFoundKernelException e) {
            throw new RuntimeException(e);
        }
    }

    public static IndexSample combine(IndexSample sample1, IndexSample sample2) {
        long indexSize = Math.addExact(sample1.indexSize(), sample2.indexSize());
        long uniqueValues = Math.addExact(sample1.uniqueValues(), sample2.uniqueValues());
        long sampleSize = Math.addExact(sample1.sampleSize(), sample2.sampleSize());
        return new IndexSample(indexSize, uniqueValues, sampleSize);
    }

    public void close() {
        IOUtils.closeAllSilently(this.indexSamplers);
    }
}

