/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.backup;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;
import org.apache.lucene.index.IndexCommit;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.helpers.collection.PrefetchingIterator;

class ReadOnlyIndexSnapshotFileIterator
extends PrefetchingIterator<Path>
implements ResourceIterator<Path> {
    private final Path indexDirectory;
    private final Iterator<String> fileNames;
    private final IndexCommit indexCommit;

    ReadOnlyIndexSnapshotFileIterator(Path indexDirectory, IndexCommit indexCommit) throws IOException {
        this.indexDirectory = indexDirectory;
        this.indexCommit = indexCommit;
        this.fileNames = this.indexCommit.getFileNames().iterator();
    }

    protected Path fetchNextOrNull() {
        if (!this.fileNames.hasNext()) {
            return null;
        }
        return this.indexDirectory.resolve(this.fileNames.next());
    }

    public void close() {
    }

    IndexCommit getIndexCommit() {
        return this.indexCommit;
    }

    Path getIndexDirectory() {
        return this.indexDirectory;
    }
}

