/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.trigram;

import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TotalHitCountCollector;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.internal.helpers.collection.BoundedIterable;
import org.neo4j.internal.helpers.collection.PrefetchingIterator;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.impl.index.SearcherReference;
import org.neo4j.kernel.api.impl.index.collector.DocValuesCollector;
import org.neo4j.kernel.api.impl.schema.AbstractTextIndexReader;
import org.neo4j.kernel.api.impl.schema.TaskCoordinator;
import org.neo4j.kernel.api.impl.schema.trigram.TrigramIndexSampler;
import org.neo4j.kernel.api.impl.schema.trigram.TrigramQueryFactory;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.IndexSampler;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.util.Preconditions;
import org.neo4j.values.storable.Value;

public class TrigramIndexReader
extends AbstractTextIndexReader {
    TrigramIndexReader(SearcherReference searcherReference, IndexDescriptor descriptor, IndexSamplingConfig samplingConfig, TaskCoordinator taskCoordinator) {
        super(descriptor, searcherReference, samplingConfig, taskCoordinator);
    }

    public IndexSampler createSampler() {
        return new TrigramIndexSampler(this.getIndexSearcher());
    }

    @Override
    protected Query toLuceneQuery(PropertyIndexQuery predicate) {
        switch (predicate.type()) {
            case ALL_ENTRIES: {
                return TrigramQueryFactory.allValues();
            }
            case EXACT: {
                String value = ((PropertyIndexQuery.ExactPredicate)predicate).value().asObject().toString();
                return TrigramQueryFactory.exact(value);
            }
            case STRING_PREFIX: {
                PropertyIndexQuery.StringPrefixPredicate spp = (PropertyIndexQuery.StringPrefixPredicate)predicate;
                return TrigramQueryFactory.stringPrefix(spp.prefix().stringValue());
            }
            case STRING_CONTAINS: {
                PropertyIndexQuery.StringContainsPredicate scp = (PropertyIndexQuery.StringContainsPredicate)predicate;
                return TrigramQueryFactory.stringContains(scp.contains().stringValue());
            }
            case STRING_SUFFIX: {
                PropertyIndexQuery.StringSuffixPredicate ssp = (PropertyIndexQuery.StringSuffixPredicate)predicate;
                return TrigramQueryFactory.stringSuffix(ssp.suffix().stringValue());
            }
        }
        throw new IllegalArgumentException(String.format("Index query not supported for %s index. Query: %s", IndexType.TEXT, predicate));
    }

    @Override
    protected String entityIdFieldKey() {
        return "id";
    }

    @Override
    protected boolean needStoreFilter(PropertyIndexQuery predicate) {
        return TrigramQueryFactory.needStoreFilter(predicate);
    }

    public long countIndexedEntities(long entityId, CursorContext cursorContext, int[] propertyKeyIds, Value ... propertyValues) {
        Query entityIdQuery = TrigramQueryFactory.getById(entityId);
        BooleanQuery.Builder entityIdAndValueQuery = new BooleanQuery.Builder();
        entityIdAndValueQuery.add(entityIdQuery, BooleanClause.Occur.MUST);
        Preconditions.checkState((propertyKeyIds.length == 1 ? 1 : 0) != 0, (String)"Text index does not support composite indexing. Tried to query index with multiple property keys.");
        String value = propertyValues[0].asObject().toString();
        Query valueQuery = TrigramQueryFactory.exact(value);
        entityIdAndValueQuery.add(valueQuery, BooleanClause.Occur.MUST);
        try {
            TotalHitCountCollector collector = new TotalHitCountCollector();
            this.getIndexSearcher().search((Query)entityIdAndValueQuery.build(), (Collector)collector);
            return collector.getTotalHits();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    BoundedIterable<Long> newAllEntriesValueReader(final long fromIdInclusive, final long toIdExclusive) throws IOException {
        DocValuesCollector collector = new DocValuesCollector();
        this.getIndexSearcher().search((Query)TrigramQueryFactory.allValues(), (Collector)collector);
        DocValuesCollector.EntityConsumer entityConsumer = new DocValuesCollector.EntityConsumer(){
            long reference;

            @Override
            public boolean acceptEntity(long reference, float score, Value ... values) {
                if (reference >= fromIdInclusive && reference < toIdExclusive) {
                    this.reference = reference;
                    return true;
                }
                return false;
            }
        };
        final IndexProgressor indexProgressor = collector.getIndexProgressor("id", entityConsumer);
        return new BoundedIterable<Long>(entityConsumer){
            final /* synthetic */ 1 val$entityConsumer;
            {
                this.val$entityConsumer = var3_3;
            }

            public Iterator<Long> iterator() {
                return new PrefetchingIterator<Long>(){

                    protected Long fetchNextOrNull() {
                        if (indexProgressor.next()) {
                            return val$entityConsumer.reference;
                        }
                        return null;
                    }
                };
            }

            public void close() {
                indexProgressor.close();
            }

            public long maxCount() {
                return -1L;
            }
        };
    }
}

