/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.io.IOException;
import java.nio.file.OpenOption;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.configuration.Config;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.impl.index.LuceneMinimalIndexAccessor;
import org.neo4j.kernel.api.impl.index.MinimalDatabaseIndex;
import org.neo4j.kernel.api.impl.index.SchemaIndexMigrator;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.storage.IndexStorageFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.MinimalIndexAccessor;
import org.neo4j.kernel.impl.index.schema.IndexUpdateIgnoreStrategy;
import org.neo4j.monitoring.Monitors;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.migration.StoreMigrationParticipant;
import org.neo4j.util.VisibleForTesting;
import org.neo4j.values.storable.ValueCategory;

public abstract class AbstractTextIndexProvider
extends IndexProvider {
    public static final IndexUpdateIgnoreStrategy UPDATE_IGNORE_STRATEGY = values -> values[0].valueGroup().category() != ValueCategory.TEXT;
    private final IndexStorageFactory indexStorageFactory;
    private final Config config;
    private final IndexProvider.Monitor monitor;
    private final IndexType supportedIndexType;

    public AbstractTextIndexProvider(IndexType supportedIndexType, IndexProviderDescriptor descriptor, FileSystemAbstraction fileSystem, DirectoryFactory directoryFactory, IndexDirectoryStructure.Factory directoryStructureFactory, Monitors monitors, Config config) {
        super(descriptor, directoryStructureFactory);
        this.supportedIndexType = supportedIndexType;
        this.monitor = (IndexProvider.Monitor)monitors.newMonitor(IndexProvider.Monitor.class, new String[]{descriptor.toString()});
        this.indexStorageFactory = this.buildIndexStorageFactory(fileSystem, directoryFactory);
        this.config = config;
    }

    @VisibleForTesting
    protected IndexStorageFactory buildIndexStorageFactory(FileSystemAbstraction fileSystem, DirectoryFactory directoryFactory) {
        return new IndexStorageFactory(directoryFactory, fileSystem, this.directoryStructure());
    }

    public void validatePrototype(IndexPrototype prototype) {
        IndexType indexType = prototype.getIndexType();
        if (indexType != this.supportedIndexType) {
            String providerName = this.getProviderDescriptor().name();
            throw new IllegalArgumentException("The '" + providerName + "' index provider does not support " + indexType + " indexes: " + prototype);
        }
        if (prototype.isUnique()) {
            throw new IllegalArgumentException("The '" + this.getProviderDescriptor().name() + "' index provider does not support unique indexes: " + prototype);
        }
    }

    public MinimalIndexAccessor getMinimalIndexAccessor(IndexDescriptor descriptor) {
        PartitionedIndexStorage indexStorage = this.indexStorageFactory.indexStorageOf(descriptor.getId());
        MinimalDatabaseIndex index = new MinimalDatabaseIndex(indexStorage, descriptor, this.config);
        return new LuceneMinimalIndexAccessor(descriptor, index, true);
    }

    public InternalIndexState getInitialState(IndexDescriptor descriptor, CursorContext cursorContext, ImmutableSet<OpenOption> openOptions) {
        PartitionedIndexStorage indexStorage = this.getIndexStorage(descriptor.getId());
        String failure = indexStorage.getStoredIndexFailure();
        if (failure != null) {
            return InternalIndexState.FAILED;
        }
        try {
            return AbstractTextIndexProvider.indexIsOnline(indexStorage, descriptor, this.config) ? InternalIndexState.ONLINE : InternalIndexState.POPULATING;
        }
        catch (IOException e) {
            this.monitor.failedToOpenIndex(descriptor, "Requesting re-population.", (Exception)e);
            return InternalIndexState.POPULATING;
        }
    }

    public StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction fs, PageCache pageCache, PageCacheTracer pageCacheTracer, StorageEngineFactory storageEngineFactory, CursorContextFactory contextFactory) {
        return new SchemaIndexMigrator(this.getProviderDescriptor().name(), fs, pageCache, pageCacheTracer, this.directoryStructure(), storageEngineFactory, contextFactory);
    }

    public String getPopulationFailure(IndexDescriptor descriptor, CursorContext cursorContext, ImmutableSet<OpenOption> openOptions) throws IllegalStateException {
        return (String)StringUtils.defaultIfEmpty((CharSequence)this.getIndexStorage(descriptor.getId()).getStoredIndexFailure(), (CharSequence)"");
    }

    protected PartitionedIndexStorage getIndexStorage(long indexId) {
        return this.indexStorageFactory.indexStorageOf(indexId);
    }

    public static boolean indexIsOnline(PartitionedIndexStorage indexStorage, IndexDescriptor descriptor, Config config) throws IOException {
        try (MinimalDatabaseIndex index = new MinimalDatabaseIndex(indexStorage, descriptor, config);){
            if (index.exists()) {
                index.open();
                boolean bl = index.isOnline();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public IndexDescriptor completeConfiguration(IndexDescriptor index) {
        return index;
    }
}

